<div class="row">
	<div class="col-md-12">
		<section class="panel">
			<header class="panel-heading">
				<h4 class="panel-title"><i class="far fa-folder"></i> <?php echo translate('homework') . "  " . translate('list'); ?></h4>
			</header>
			<div class="panel-body">
				<section class="panel-group mt-md" id="accordion">
					<?php foreach ($homeworklist as $key => $row) :
						if ($row['currentTime'] >= $row['startDateTime']) :
							?>
							<div class="panel panel-accordion">
								<div class="panel-heading">
									<h4 class="panel-title">
										<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#<?php echo $row['id']; ?>">
											<i class="far fa-sticky-note"></i> <?php echo $row['subject_name'] ?> - <?= _d($row['date_of_homework']) ?>
										</a>
									</h4>
								</div>
								<div id="<?php echo $row['id']; ?>" class="accordion-body collapse">
									<div class="panel-body">
										<div class="row">
											<div class="col-md-7">
												<p><?php echo $row['description']; ?></p>
											</div>
											<div class="col-md-5">
												<ul class="nav nav-stacked">
													<li><i class="far fa-calendar"></i> <span class="text-weight-semibold"><?= translate('date_of_homework') ?></span> : <?= _d($row['date_of_homework']) ?> : <?php echo date("h:i A", strtotime($row['start_time'])); ?></li>
													<li><i class="far fa-calendar"></i> <span class="text-weight-semibold"><?= translate('date_of_submission') ?></span> : <?= _d($row['date_of_submission']) ?> : <?php echo date("h:i A", strtotime($row['end_time'])); ?></li>
													<li><i class="far fa-calendar"></i> <span class="text-weight-semibold"><?= translate('evaluation_date') ?></span> : <?= $row['evaluation_date'] != null ? _d($row['evaluation_date']) : "N/A"; ?></li>
													<li><span class="text-weight-semibold"><?= translate('created_by') ?></span> : <?= $row['created_by'] != null ? get_type_name_by_id('staff', $row['created_by']) : "N/A"; ?></li>
													<li><span class="text-weight-semibold"><?= translate('status') ?></span> : <?php
// if (!$row['late']) {
													if ($row['ev_status'] == 'u' || $row['ev_status'] == '') {
														if ($row['exisit']) {
															$labelmode = 'label-success-custom';
															$status = translate('pending');
														} else {
															if ($row['late']) {
																$labelmode = 'label-danger-custom';
																$status = translate('submission date has been passed');
															} else {
																$labelmode = 'label-danger-custom';
																$status = translate('incomplete');
															}
														}
													} else {
// if (!$row['late']) {
// 	$labelmode = 'label-danger-custom';
// 	$status = translate('submission date has been passed');
// } 
// else {
														$status = translate('complete');
														$labelmode = 'label-success-custom';
// };
													}
// } else {

// }
													echo "<span class='value label " . $labelmode . " '>" . $status . "</span>";
													?></li>
													<li><span class="text-weight-semibold"><?= translate('evaluated_by') ?></span> : <?= !empty($row['evaluated_by']) ? get_type_name_by_id('staff', $row['evaluated_by']) : "N/A"; ?></li>
													<li><span class="text-weight-semibold"><?= translate('rank_out_of_5') ?></span> : <?= !empty($row['rank']) ? $row['rank'] : "N/A"; ?></li>
													<li><span class="text-weight-semibold"><?= translate('remarks') ?></span> : <?= !empty($row['ev_remarks']) ? $row['ev_remarks'] : "N/A"; ?></li>
												</ul>
												<ul class="nav nav-stacked mt-md">
													<li><span class="text-weight-semibold"><?= translate('subject') ?></span> : <?= $row['subject_name'] ?></li>
													<li><span class="text-weight-semibold"><?= translate('class') ?></span> : <?= $row['class_name'] ?></li>
													<li><span class="text-weight-semibold"><?= translate('section') ?></span> : <?= $section_name ?></li>
													<li><span class="text-weight-semibold"><?= translate('documents') ?></span> : <a href="<?= base_url($row['document']) ?>" target="_blank" style="display: initial;" class="btn btn-default btn-circle icon" data-toggle="tooltip" data-original-title="<?= translate('download') ?>"><i class="fas fa-cloud-download-alt"></i></a></li>

													<li class="mt-md">
														<?php
														if ($row['exisit']) {
															$labelmode = 'label-success-custom';
															$status = translate('Uploaded');
															echo "<span class='upload-status value label " . $labelmode . " '>" . $status . "</span>";
														} else {
															if (!$row['late']) {
																?>
																<?php echo form_open_multipart($this->uri->uri_string(), array('class' => 'form-bordered form-horizontal frm-submit-data')); ?>
																<div class="form-group">
																	<input type="hidden" name="homework_id" value="<?php echo $row['id'] ?>">
																	<div class="fileupload fileupload-new" data-provides="fileupload">
																		<div class="input-append">
																			<div class="uneditable-input">
																				<i class="fas fa-file fileupload-exists" style="top: 10px;left: 0px;"></i>
																				<span class="fileupload-preview"></span>
																			</div>
																			<span class="btn btn-default btn-file">
																				<span class="fileupload-exists">Change</span>
																				<span class="fileupload-new">Select file</span>
																				<input type="file" name="attachment_file" />
																			</span>
																			<a href="#" class="btn btn-default fileupload-exists" data-dismiss="fileupload">Remove</a>
																		</div>
																	</div>
																	<span class="error"></span>
																</div>
																<div class="col-md-offset-2 col-md-5">
																	<button type="submit" class="btn btn-default btn-block" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
																		<i class="fas fa-plus-circle"></i> <?= translate('submit') ?>
																	</button>
																</div>
															<?php }
														} ?>
													</li>
												</ul>
											</div>
										</div>
									</div>
								</div>
							</div>
							<?php
						endif;
					endforeach; ?>
				</section>
			</div>
		</section>
	</div>
</div>