<section class="panel">
	<div class="tabs-custom">
		<ul class="nav nav-tabs">
			<li>
				<a href="<?=base_url('subject/teacher_assign')?>"><i class="fas fa-list-ul"></i> <?=translate('teacher_assign_list')?></a>
			</li>
			<li class="active">
				<a href="#edit" data-toggle="tab"><i class="far fa-edit"></i> <?=translate('edit') . ' ' . translate('subject')?></a>
			</li>
		</ul>
		<div class="tab-content">
			<div id="edit" class="tab-pane active">
            <?php echo form_open($this->uri->uri_string(), array('class' => 'form-horizontal form-bordered frm-submit')); ?>
					<?php if (is_superadmin_loggedin()) : ?>
						<div class="form-group">
							<label class="control-label col-md-3"><?= translate('branch') ?> <span class="required">*</span></label>
							<div class="col-md-6">
								<?php
								$arrayBranch = $this->app_lib->getSelectList('branch');
								echo form_dropdown("branch_id", $arrayBranch, $subject_assign['branch_id'], "class='form-control' id='branch_id'
									data-width='100%' data-plugin-selectTwo  data-minimum-results-for-search='Infinity'");
								?>
								<span class="error"></span>
							</div>
						</div>
					<?php endif; ?>
					<div class="form-group">
						<label class="col-md-3 control-label"><?= translate('teacher') ?> <span class="required">*</span></label>
						<div class="col-md-6">
							<?php
							$arrayTeacher = $this->app_lib->getStaffList($subject_assign['branch_id'], 3);
							echo form_dropdown("staff_id", $arrayTeacher, $subject_assign['teacher_id'], "class='form-control' id='staff_id'
								data-plugin-selectTwo data-width='100%' ");
							?>
							<span class="error"></span>
						</div>
					</div>
					<div class="form-group">
						<label class="col-md-3 control-label"><?= translate('class') ?> <span class="required">*</span></label>
						<div class="col-md-6">
                        <?php						
						$arrayClass = $this->app_lib->getClass($subject_assign['branch_id']);
						echo form_dropdown("class_id", $arrayClass, $subject_assign['class_id'], "class='form-control' id='class_id' onchange='getSectionByClass(this.value,0)'
						data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
						?>
							<span class="error"></span>
						</div>
					</div>
					<div class="form-group">
						<label class="col-md-3 control-label"><?= translate('section') ?> <span class="required">*</span></label>
						<div class="col-md-6">
							<?php
                            $arraySection = $this->app_lib->getSections($subject_assign['class_id']);
							echo form_dropdown("section_id", $arraySection, $subject_assign['section_id'], "class='form-control' id='section_id' 
								data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
							?>
							<span class="error"></span>
						</div>
					</div>
					<div class="form-group">
						<label class="col-md-3 control-label"><?= translate('subject') ?> <span class="required">*</span></label>
						<div class="col-md-6 mb-md">
						<?php						
						if (!empty($subject_assign['class_id'])) {
							$arraySubject = array("" => translate('select'));
							$assigns = $this->db->select('subject_id')->from('subject_assign')->where('class_id' , $subject_assign['class_id'])->where_in('section_id' , $sel)->get()->result_array();
							foreach ($assigns as $row) {
								$arraySubject[$row['subject_id']] = get_type_name_by_id('subject', $row['subject_id']);
							}
						} else {
							$arraySubject = array("" => translate('select_class_first'));

						}
							echo form_dropdown("subject_id", $arraySubject, $subject_assign['subject_id'], "class='form-control' id='subject_id'
							data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
						?>
							<span class="error"></span>
						</div>
					</div>
					<footer class="panel-footer">
						<div class="row">
							<div class="col-md-offset-3 col-md-2">
								<button type="submit" class="btn btn-default btn-block" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
									<i class="fas fa-plus-circle"></i> <?= translate('save') ?>
								</button>
							</div>
						</div>
					</footer>
					<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</section>
<script type="text/javascript">
	$(document).ready(function() {
		$(document).on('change', '#branch_id', function() {
			var branchID = $(this).val();
			getClassByBranch(branchID);
			getStaffListRole(branchID, 3);
			$('#teacher_id').html('').append('<option value=""><?= translate("select_department_first") ?></option>');
			$('#subject_id').html('').append('<option value=""><?= translate("select") ?></option>');
		});

		$(document).on('change', '#class_id', function() {
			var classID = $(this).val();
			getSectionByClass(classID, 0);
			$('#subject_id').html('').append('<option value=""><?= translate("select") ?></option>');
		});

		$(document).on('change', '#section_id', function() {
			var sectionID = $(this).val();
			var classID = $('#class_id').val();
			$.ajax({
				url: base_url + 'subject/getByClassSection',
				type: 'POST',
				data: {
					sectionID: sectionID,
					classID: classID
				},
				success: function(data) {
					$('#subject_id').html(data);
				}
			});
		});
	});
</script>