<?php $widget = (is_superadmin_loggedin() ? 3 : 4); ?>
<div class="row">
	<div class="col-md-12">
		<section class="panel">
			<?php echo form_open($this->uri->uri_string(), array('class' => 'validate')); ?>
			<header class="panel-heading">
				<h4 class="panel-title"><?= translate('select_ground') ?></h4>
				<?php if (get_permission('quiz', 'is_add')) : ?>
					<div class="panel-btn">
						<a href="<?= base_url('quiz/add') ?>" id="addLeave" class="btn btn-default btn-circle">
							<i class="fas fa-plus-circle"></i> <?= translate('add') . " " . translate('quiz') ?>
						</a>
					</div>
				<?php endif; ?>
			</header>
			<div class="panel-body">
				<div class="row mb-sm">
					<?php if (is_superadmin_loggedin()) : ?>
						<div class="col-md-6 mb-sm">
							<div class="form-group">
								<label class="ontrol-label"><?= translate('branch') ?> <span class="required">*</span></label>
								<?php
								$arrayBranch = $this->app_lib->getSelectList('branch');
								echo form_dropdown("branch_id", $arrayBranch, set_value('branch_id'), "class='form-control' id='branch_id'
								data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'");
								?>
							</div>
						</div>
					<?php endif; ?>
					<div class="col-md-6 mb-sm">
						<div class="form-group">
							<label class="control-label"><?= translate('class') ?> <span class="required">*</span></label>
							<?php
							$arrayClass = $this->app_lib->getClass($branch_id);
							echo form_dropdown("class_id", $arrayClass, set_value('class_id'), "class='form-control' id='class_id' onchange='getSectionByClass(this.value,0)'
								required data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
							?>
						</div>
					</div>
				</div>
			</div>
			<footer class="panel-footer">
				<div class="row">
					<div class="col-md-offset-10 col-md-2">
						<button type="submit" name="search" value="1" class="btn btn btn-default btn-block"> <i class="fas fa-filter"></i> <?= translate('filter') ?></button>
					</div>
				</div>
			</footer>
			<?php echo form_close(); ?>
		</section>

		<?php if (isset($quizlist)) : ?>
			<section class="panel appear-animation" data-appear-animation="<?php echo $global_config['animations']; ?>" data-appear-animation-delay="100">
				<header class="panel-heading">
					<h4 class="panel-title"><i class="fas fa-list"></i> <?= translate('quiz') ?></h4>
				</header>
				<div class="panel-body">
					<table class="table table-bordered table-export">
						<thead>
							<tr>
								<th><?= translate('sl') ?></th>
								<th><?= translate('subject') ?></th>
								<th><?= translate('class') ?></th>
								<th><?= translate('section') ?></th>
								<th><?= translate('quiz_title') ?></th>
								<th><?= translate('publish_date') ?></th>
								<th><?= translate('start_time') ?></th>
								<th><?= translate('expire_date') ?></th>
								<th><?= translate('end_time') ?></th>
								<th><?= translate('total_marks') ?></th>
								<th><?= translate("quiz's_time") ?></th>
								<th><?= translate('created_at') ?></th>
								<th><?= translate('created_by') ?></th>
								<th><?= translate('action') ?></th>
							</tr>
						</thead>
						<tbody>
							<?php $count = 1;
							foreach ($quizlist as $row) { ?>
								<tr>
									<td><?php echo $count++; ?></td>
									<td><?php echo $row['subject_name']; ?></td>
									<td><?php echo $row['class_name']; ?></td>
									<td><?php echo $row['section_details']; ?></td>
									<td><?php echo $row['title']; ?></td>
									<!-- <td>
										<iframe id="quiz<?= $count ?>" width="250" height="150" src="<?= strip_tags($row['url']) ?>" frameborder="0" allowtransparency="true" allowfullscreen>
										</iframe>
									</td> -->
									<td><?php echo _d($row['publish_date']); ?></td>
									<td><?php echo date("h:i A", strtotime($row['start_time'])); ?></td>
									<td><?php echo _d($row['expire_date']); ?></td>
									<td><?php echo date("h:i A", strtotime($row['end_time'])); ?></td>
									<td><?php echo $row['total_marks']; ?></td>
									<td><?php echo $row['quiz_time']; ?></td>
									<td><?php echo _d($row['create_date']); ?></td>
									<td><?php echo $row['creator_name']; ?></td>
									<td class="min-w-sm">
										<?php if (get_permission('quiz', 'is_edit')) { ?>
											<a href="javascript:void(0);" class="btn btn-circle btn-default icon" data-toggle="tooltip" data-original-title="<?= translate('evaluate') ?>" onclick="getEvaluate(<?= $row['id'] ?>)">
												<i class="fas fa-bars"></i>
											</a>
											<a href="<?php echo base_url('quiz/edit/' . $row['id']); ?>" class="btn btn-circle btn-default icon">
												<i class="fas fa-pen-nib"></i>
											</a>
										<?php }
										if (get_permission('quiz', 'is_delete')) { ?>
											<?php echo btn_delete('quiz/delete/' . $row['id']); ?>
										<?php } ?>
									</td>
								</tr>
							<?php } ?>
						</tbody>
					</table>
				</div>
				<?php echo form_close(); ?>
			</section>
		<?php endif; ?>
	</div>
</div>
<div class="zoom-anim-dialog modal-block modal-block-lg mfp-hide" id="modal">
	<section class="panel">
		<header class="panel-heading">
			<h4 class="panel-title"><i class="fas fa-bars"></i> <?php echo translate('evaluate'); ?></h4>
		</header>
		<div class="panel-body">
			<div id='quick_view'></div>
		</div>
		<footer class="panel-footer">
			<div class="row">
				<div class="col-md-12 text-right">
					<button class="btn btn-default modal-dismiss"><?php echo translate('close'); ?></button>
				</div>
			</div>
		</footer>
	</section>
</div>.
<script type="text/javascript">
	$(document).ready(function() {
		$('#branch_id').on('change', function() {
			var branchID = $(this).val();
			getClassByBranch(branchID);
			$('#subject_id').html('').append('<option value=""><?= translate("select") ?></option>');
		});

		$('#section_id').on('change', function() {
			var classID = $('#class_id').val();
			var sectionID = $(this).val();
			$.ajax({
				url: base_url + 'subject/getByClassSection',
				type: 'POST',
				data: {
					classID: classID,
					sectionID: sectionID
				},
				success: function(data) {
					$('#subject_id').html(data);
				}
			});
		});
	});

	// get details
	function getEvaluate(id) {
		$.ajax({
			url: base_url + 'quiz/evaluateModal',
			type: 'POST',
			data: {
				'quiz_id': id
			},
			dataType: "html",
			success: function(data) {
				$('#quick_view').html(data);
				mfp_modal('#modal');
			}
		});
	}
</script>