<div class="row">
    <div class="col-md-12">
        <section class="panel">
            <?php echo form_open_multipart($this->uri->uri_string(), array('class' => 'form-bordered form-horizontal frm-submit-data')); ?>
            <input type="hidden" name="quiz_id" value="<?= $quiz['id'] ?>">
            <input name="step" type="hidden" class="form-control" value="step1">
            <header class="panel-heading">
                <h4 class="panel-title"><i class="fas fa-plus-circle"></i> <?= translate('edit') . " " . translate('quiz') ?></h4>
            </header>
            <div class="panel-body mb-md">
                <div class="mt-md"></div>
                <?php if (is_superadmin_loggedin()) : ?>
                    <div class="form-group">
                        <label class="control-label col-md-3"><?= translate('branch') ?> <span class="required">*</span></label>
                        <div class="col-md-6">
                            <?php
                            $arrayBranch = $this->app_lib->getSelectList('branch');
                            echo form_dropdown("branch_id", $arrayBranch, $quiz['branch_id'], "class='form-control' id='branch_id'
								data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'");
                            ?>
                            <span class="error"></span>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="form-group">
                    <label class="col-md-3 control-label"><?= translate('class') ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <?php
                        $arrayClass = $this->app_lib->getClass($quiz['branch_id']);
                        echo form_dropdown("class_id", $arrayClass, $quiz['class_id'], "class='form-control' id='class_id' onchange='getSectionByClass(this.value,0)'
							data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
                        ?>
                        <span class="error"></span>
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-md-3 control-label"><?= translate('section') ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <?php
                        $sel = json_decode($quiz['section_id'], true);
                        $arraySections = $this->app_lib->getSections($quiz['class_id'], false, true);
                        echo form_dropdown("section_id[]", $arraySections, $sel, "class='form-control' id='section_id' data-plugin-selectTwo data-width='100%' multiple
								data-minimum-results-for-search='Infinity' ");
                        ?>
                        <span class="error"></span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label"><?= translate('subject') ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <?php
                        if (!empty($quiz['class_id'])) {
                            $arraySubject = array("" => translate('select'));
                            $assigns = $this->db->select('subject_id')->from('subject_assign')->where('class_id', $quiz['class_id'])->where_in('section_id', $sel)->get()->result_array();
                            foreach ($assigns as $row) {
                                $arraySubject[$row['subject_id']] = get_type_name_by_id('subject', $row['subject_id']);
                            }
                        } else {
                            $arraySubject = array("" => translate('select_class_first'));
                        }
                        echo form_dropdown("subject_id", $arraySubject, $quiz['subject_id'], "class='form-control' id='subject_id'
							data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
                        ?>
                        <span class="error"></span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label"><?= translate('title') ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <input id="title" name="title" type="text" class="form-control" value="<?= $quiz['title'] ?>">
                        <span class="error"></span>
                    </div>
                </div>

                <div class="form-group">
                    <div class="col-md-3">
                        <label class="col-md-12 control-label"><?= translate('quiz_setting') ?> <span class="required">*</span></label>
                    </div>
                    <div class="col-md-6">
                        <!-- timer -->
                        <div class="col-md-4">
                            <label class="col-md-12 p-0"><?= translate('timer') ?> <span class="required">*</span></label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" onclick="timerStatus(this)" value="1" name="setting[timer]" <?php echo $quiz['quiz_setting']['timer'] ? 'checked' : '' ?> id="timer">
                            <label for="timer">Active</label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" value="0" onclick="timerStatus(this)" <?php echo !$quiz['quiz_setting']['timer'] ? 'checked' : '' ?> name="setting[timer]" id="timer">
                            <label for="timer">Unactive</label>
                        </div>
                        <!-- copy paste -->
                        <div class="col-md-4">
                            <label class="col-md-12 p-0"><?= translate('copy_&_paste') ?> <span class="required">*</span></label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" value="0" name="setting[cp]" <?php echo !$quiz['quiz_setting']['cp'] ? 'checked' : '' ?> checked id="cp">
                            <label for="cp">Allow</label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" value="1" name="setting[cp]" <?php echo $quiz['quiz_setting']['cp'] ? 'checked' : '' ?> id="cp">
                            <label for="cp">Not Allow</label>
                        </div>
                        <!-- focus out -->
                        <div class="col-md-4">
                            <label class="col-md-12 p-0"><?= translate('focus_out') ?> <span class="required">*</span></label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" value="0" name="setting[focus]" <?php echo !$quiz['quiz_setting']['focus'] ? 'checked' : '' ?> id="focus">
                            <label for="cp">Allow</label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" value="1" name="setting[focus]" <?php echo $quiz['quiz_setting']['focus'] ? 'checked' : '' ?> id="focus">
                            <label for="cp">Not Allow</label>
                        </div>
                        <!-- refresh -->
                        <div class="col-md-4">
                            <label class="col-md-12 p-0"><?= translate('refresh') ?> <span class="required">*</span></label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" value="0" name="setting[refresh]" <?php echo !$quiz['quiz_setting']['refresh'] ? 'checked' : '' ?> checked id="refresh">
                            <label for="refresh">Allow</label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" value="1" name="setting[refresh]" <?php echo $quiz['quiz_setting']['refresh'] ? 'checked' : '' ?> id="refresh">
                            <label for="refresh">Not Allow</label>
                        </div>
                        <!-- refresh -->
                        <div class="col-md-4">
                            <label class="col-md-12 p-0"><?= translate('show_quiz_URL') ?> <span class="required">*</span></label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" value="1" name="setting[url]" <?php echo $quiz['quiz_setting']['url'] ? 'checked' : '' ?> checked id="url">
                            <label for="url">Allow</label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" value="0" name="setting[url]" <?php echo !$quiz['quiz_setting']['url'] ? 'checked' : '' ?> id="url">
                            <label for="url">Not Allow</label>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label"><?= translate('total_marks') ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <input id="total_marks" name="total_marks" type="number" class="form-control" min="0" value="<?= $quiz['total_marks'] ?>">
                        <span class="error"></span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label"><?= translate("Quiz's_time") ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <?php// echo $quiz['quiz_setting']['timer'] ? '': 'disabled' ?>
                        <input id="quiz_time" name="quiz_time" type="number" class="form-control" min="0" <?= $quiz['quiz_setting']['timer'] ? '' : 'disabled' ?> value="<?= $quiz['quiz_setting']['timer'] ? $quiz['quiz_time'] : '' ?>">
                        <span class="error"></span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label"><?= translate('publish_date') ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <div class="input-group">
                            <span class="input-group-addon"><i class="far fa-calendar-alt"></i></span>
                            <input type="text" class="form-control" name="publish_date" id="publish_date" value="<?= $quiz['publish_date'] ?>" autocomplete="off" data-plugin-datepicker data-plugin-options='{ "todayHighlight" : true }' />
                        </div>
                        <span class="error"></span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label"><?= translate('expire_date') ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <div class="input-group">
                            <span class="input-group-addon"><i class="far fa-calendar-alt"></i></span>
                            <input type="text" class="form-control" name="expire_date" value="<?= $quiz['expire_date'] ?>" autocomplete="off" data-plugin-datepicker data-plugin-options='{ "todayHighlight" : true }' />
                        </div>
                        <span class="error"></span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label"><?php echo translate('time_slot'); ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <div class="row">
                            <div class="col-xs-6">
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="far fa-clock"></i></span>
                                    <input type="text" data-plugin-timepicker class="form-control" name="time_start" value="<?= $quiz['start_time'] ?>" />
                                </div>
                                <span class="error"></span>
                            </div>
                            <div class="col-xs-6">
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="far fa-clock"></i></span>
                                    <input type="text" data-plugin-timepicker class="form-control" name="time_end" value="<?= $quiz['end_time'] ?>" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- <div class="form-group">
                    <div class="col-md-offset-3 col-md-6">
                        <div class="checkbox-replace">
                            <label class="i-checks"><input type="checkbox" name="timerStatus" <?= $quiz['status'] == 1 ? 'checked' : ''; ?> id="timerStatus"><i></i> Timer Per Question</label>
                        </div>
                    </div>
                    <div class="col-md-12 mt-sm"></div>
                    <label class="col-md-3 control-label">Minutes<span class="required">*</span></label>
                    <div class="col-md-6">
                        <div class="input-group">
                            <span class="input-group-addon"><i class="far fa-clock"></i></span>
                            <input type="number" class="form-control" name="timer" value="<?= $quiz['timer_minutes'] ?>" id="timer" min="0" disabled />
                        </div>
                        <span class="error"></span>
                    </div>
                </div> -->
            </div>
            <footer class="panel-footer">
                <div class="row">
                    <div class="col-md-offset-3 col-md-2">
                        <button type="submit" class="btn btn-default btn-block" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
                            <i class="fas fa-plus-circle"></i> <?= translate('update') ?>
                        </button>
                    </div>
                </div>
            </footer>
            <?php echo form_close(); ?>
        </section>
    </div>
</div>
<script type="text/javascript">
    var quizType = '';
    $(document).ready(function() {
        $('#branch_id').on('change', function() {
            var branchID = $(this).val();
            getClassByBranch(branchID);
            $('#subject_id').html('').append('<option value=""><?= translate("select") ?></option>');
        });

        $('#section_id').on('change', function() {
            var classID = $('#class_id').val();
            var sectionID = $(this).val();
            $.ajax({
                url: base_url + 'subject/getByClassSection',
                type: 'POST',
                data: {
                    classID: classID,
                    sectionID: sectionID
                },
                success: function(data) {
                    $('#subject_id').html(data);
                }
            });
        });
        $('#timerStatus').on('change', function() {
            if ($(this).is(':checked')) {
                var date_of_quiz = $('#date_of_quiz').val()
                $('#timer').val(date_of_quiz);
                $('#timer').prop("disabled", false);
            } else {
                $('#timer').val("");
                $('#timer').prop("disabled", true);
            }
        });
    });

    function timerStatus(self) {
        var value = $(self).val()
        if (value == 1) {
            $('#quiz_time').prop("disabled", false);
        }
        if (value == 0) {
            $('#quiz_time').val("");
            $('#quiz_time').prop("disabled", true);
        }
    }
</script>