<section class="panel">
    <div class="tabs-custom">
        <ul class="nav nav-tabs">
            <?php if (get_permission('download_pdfs', 'is_view')) { ?>
                <li class="active">
                    <a href="#update_database" data-toggle="tab">
                        <i class="icon-pencil"></i> <?= translate('Download_PDF') ?>
                    </a>
                </li>
            <?php } ?>
        </ul>
        <div class="tab-content">
            <?php if (get_permission('update', 'is_add')) { ?>
                <?php echo form_open($this->uri->uri_string(), array('class' => 'form-horizontal form-bordered validate', 'id' => 'download_pdf')); ?>
                <?php if (is_superadmin_loggedin()) : ?>
                    <div class="form-group mt-md">
                        <input type="hidden" name="action" value="html">
                        <label class="col-md-3 control-label"><?= translate('branch') ?> <span class="required">*</span></label>
                        <div class="col-md-6">
                            <?php
                            $arrayBranch = $this->app_lib->getSelectList('branch');
                            echo form_dropdown("branch_id", $arrayBranch, set_value('branch_id'), "class='form-control' id='branch_id'
								data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'");
                            ?>
                            <span class="error"><?= form_error('branch_id') ?></span>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="form-group">
                    <label class="col-md-3 control-label"><?= translate('class') ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <?php
                        $arrayClass = $this->app_lib->getClass('');
                        echo form_dropdown("class_id", $arrayClass, set_value('class_id'), "class='form-control' id='class_id' onchange='getSectionByClass(this.value,0)'
								data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
                        ?>
                        <span class="error"><?= form_error('class_id') ?></span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label"><?= translate('section') ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <?php
                        $arraySection = $this->app_lib->getSections(set_value('class_id'), false);
                        echo form_dropdown("section_id", $arraySection, set_value('section_id'), "class='form-control' id='section_id' 
								data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
                        ?>
                        <span class="error"><?= form_error('section_id') ?></span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label"><?= translate('GR_no') ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <input type="text" class="form-control" name="register_no" value="<?= set_value('GR') ?>">
                        <span class="error"><?= form_error('mobileno') ?></span>
                    </div>
                </div>
                <footer class="panel-footer mt-lg">
                    <div class="row">
                        <div class="col-md-2 col-md-offset-3">
                            <button type="submit" class="btn btn-default btn-block" name="submit" value="save" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
                                <i class="fas fa-cloud-upload-alt"></i> <?= translate('Download') ?> PDF
                            </button>
                        </div>
                    </div>
                </footer>
                <?php echo form_close(); ?>
            <?php } ?>
        </div>
    </div>
</section>
<script>
    $(document).ready(function() {
        $(document).on('change', '#branch_id', function() {
            var branchID = $(this).val();
            $.ajax({
                url: base_url + "ajax/getClassByBranch",
                type: 'POST',
                data: {
                    branch_id: branchID
                },
                success: function(data) {
                    $('#class_id').html(data);
                }
            });
        });
    });
    $(document).on('submit', '#download_pdf', function() {
        let self = $(this);
        download(self);
        return false;
    });

    function download(self) {
        let oForm = self.serializeArray();
        var btn = self.find('[type="submit"]');
        $.ajax({
            url: self.attr('action'),
            type: 'POST',
            data: oForm,
            dataType: "json",
            beforeSend: function() {
                btn.button('loading');
            },
            success: function(data) {
                $('.error').html("");
                if (data != null) {
                    if (data.status == "fail") {
                        $.each(data.error, function(index, value) {
                            self.find("[name='" + index + "']").parents('.form-group').find('.error').html(value);
                        });
                        btn.button('reset');
                    } else {
                        if (typeof data.url != 'undefined') {
                            window.location.href = data.url;
                        } else if (data.status == "access_denied") {
                            window.location.href = base_url + "dashboard";
                        } else if (data.msg.req == "render") {
                            $('[name="action"]').val(data.msg.req);
                            // console.log($('[name="action"]').val())
                            $('form#download_pdf').submit();
                        } else {
                            btn.button('reset');
                            downloadFile('tfs.pdf', 'TFS');
                        }
                        // else {
                        //     location.reload(true);
                        // }
                    }
                }
            },
        });
    }

    function downloadFile(url, fileName = false) {
        let a = document.createElement('a');
        let ext = '.' + url.split('.').pop();
        a.setAttribute('href', url);
        a.innerText = 'This is link';
        a.setAttribute('download', (fileName ? fileName : 'file') + ext);
        document.getElementsByTagName('body')[0].appendChild(a);
        a.click();
    }
</script>