<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Video_model extends MY_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function getList($classID, $branchID)
    {
        $this->db->select('video.*,subject.name as subject_name,class.name as class_name,section.name as section_name,staff.name as creator_name');
        $this->db->from('video');
        $this->db->join('subject', 'subject.id = video.subject_id', 'left');
        $this->db->join('class', 'class.id = video.class_id', 'left');
        $this->db->join('section', 'section.id = video.section_id', 'left');
        $this->db->join('staff', 'staff.id = video.created_by', 'left');
        $this->db->where('video.class_id', $classID);
        // $this->db->where('video.section_id', $sectionID);
        // $this->db->where('video.subject_id', $subjectID);
        $this->db->where('video.branch_id', $branchID);
        $this->db->where('video.session_id', get_session_id());
        $this->db->order_by('video.id', 'desc');
        $result = $this->db->get()->result_array();
        foreach ($result as $key => $value) {
            $result[$key]['section_details'] = $this->getSectionDetails($value['section_id']);
        }  
        return $result;
    }
    function getSectionDetails($data)
    {
        $array = json_decode($data, true);
        $nameList = '';
        if (json_last_error() == JSON_ERROR_NONE) {
            foreach ($array as $key => $value) {
                $nameList .= get_type_name_by_id('section', $value) . '<br>';
            }
        }
        return $nameList;
    }
    // save student video in DB
    public function save($data)
    {
    	$status = isset($data['published_later']) ? TRUE : FALSE;
        $sms_notification = isset($data['notification_sms']) ? TRUE : FALSE;
    	$arrayVideo = array(
    		'branch_id' => $this->application_model->get_branch_id(),
    		'class_id' => $data['class_id'],
    		'section_id' => json_encode($data['section']), 
    		'session_id' => get_session_id(), 
    		'subject_id' => $data['subject_id'], 
            'url' => $this->urlHanlder($data['url']),
            'provided_url' => $data['url'],
    		'description' => $data['description'],
    		'created_by' => get_loggedin_user_id(), 
    		'create_date' => date("Y-m-d"), 
    		'status' => $status, 
            'publish_date' => $data['publish_date'],
    		'expire_date' => $data['expire_date'],
    	);
        if (isset($data['video_id'])) {
            if (!is_superadmin_loggedin()) 
                $this->db->where('branch_id', get_loggedin_branch_id());
            $this->db->where('id', $data['video_id']);
            $this->db->update('video', $arrayVideo);
            $insert_id = $data['video_id'];
        } else {
            $this->db->insert('video', $arrayVideo);
            $insert_id = $this->db->insert_id();
        }
    }

    protected function urlHanlder($url)
    {
        $aUrl = parse_url(trim(strip_tags($url)));
        if ($aUrl['host'] === 'drive.google.com') {
            if (!isset($aUrl['query'])) {
                throw new Exception('Error: Cannot process G-Drive Url.');
            }
            parse_str($aUrl['path'], $path);
            $path = array_keys($path);
            $path = $path[0];
            $pathComponents = explode("/",$path);
            $url = 'https://drive.google.com/file/d/'.$pathComponents[3].'/preview';
        }
        elseif ($aUrl['host'] === 'www.youtube.com') {
            if (!isset($aUrl['query'])) {
                throw new Exception('Error: Cannot process Youtube Url.');
            }
            parse_str($aUrl['query'], $aGet);
            $aGet = array_values($aGet);
            $url = 'https://www.youtube.com/embed/'.$aGet[0];
        }
        return $url;
    }
}
