<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Quiz_model extends MY_Model
{
    public function __construct()
    {
        parent::__construct();
    }
    function save($aData)
    {
        if ($aData['step'] == 'step1') {
            $status = isset($aData['timerStatus']) ? TRUE : FALSE;
            $aQuiz = array(
                'branch_id' => $this->application_model->get_branch_id(),
                'title' => $aData['title'],
                'class_id' => $aData['class_id'],
                'section_id' => json_encode($aData['section_id']),
                'session_id' => get_session_id(),
                'subject_id' => $aData['subject_id'],
                'created_by' => get_loggedin_user_id(),
                'create_date' => date("Y-m-d"),
                'status' => $status,
                'quiz_setting' => json_encode($aData['setting']),
                'total_marks' => $aData['total_marks'],
                'publish_date' => date("Y-m-d", strtotime($aData['publish_date'])),
                'expire_date' => date("Y-m-d", strtotime($aData['expire_date'])),
                'start_time' => date("H:i", strtotime($aData['time_start'])),
                'end_time' => date("H:i", strtotime($aData['time_end'])),
            );
            if ($status == TRUE) {
                $aQuiz['timer_minutes'] = $aData['timer'];
            } else {
                $aQuiz['timer_minutes'] = null;
            }
            if ($aData['setting']['timer']) {
                $aQuiz['quiz_time'] = $aData['quiz_time'];
            } else {
                $aQuiz['quiz_time'] = null;
            }
            //     echo '<pre>';
            //     print_r($this->db->select('MAX(id) as id')
            //     ->where(array('session_id' => get_session_id(),'created_by' => get_loggedin_user_id()))
            //     ->get('quiz')
            //     ->result_array()[0]['id']
            // );
            //     echo '</pre>';
            if (isset($aData['quiz_id'])) {
                // $count = $this->db->where(array('id' => $_SESSION['quiz_id']))
                //     ->get('quiz')
                //     ->num_rows();
                // if ($count == 1) {
                // if (!is_superadmin_loggedin())
                //     $this->db->where('branch_id', get_loggedin_branch_id());
                $this->db->where('id', $aData['quiz_id']);
                $this->db->update('quiz', $aQuiz);
                // } else {
                //     $this->db->insert('quiz', $aQuiz);
                //     $insertedID = $this->db->select('MAX(id) as id')
                //         ->where(array('session_id' => get_session_id(), 'created_by' => get_loggedin_user_id()))
                //         ->get('quiz')
                //         ->result_array();
                //     $this->session->set_userdata(array(
                //         'quiz_id' => $insertedID[0]['id']
                //     ));
                // }
            } else {
                $this->db->insert('quiz', $aQuiz);
                $insertedID = $this->db->select('MAX(id) as id')
                    ->where(array('session_id' => get_session_id(), 'created_by' => get_loggedin_user_id()))
                    ->get('quiz')
                    ->result_array();
                $this->session->set_userdata(array(
                    'quiz_id' => $insertedID[0]['id']
                ));
            }
        }
        if ($aData['step'] == 'step2') {
            $aQuizQuestions = array();
            foreach ($aData as $k => $v) {
                if ($k !== 'step') {
                    if (isset($v['answer'])) {
                        $v['answer'] = strtolower($v['answer']);
                    }
                    $aQuizQuestions[$k] = $v;
                }
            }
            // $insertedID = $this->db->select('MAX(id) as id')
            //         ->where(array('session_id' => get_session_id(), 'created_by' => get_loggedin_user_id()))
            //         ->get('quiz')
            //         ->result_array();
            //     $this->session->set_userdata(array(
            //         'quiz_id' => $insertedID[0]['id']
            //     ));
            $QuizQuestions = array(
                'quiz_id' => $_SESSION['quiz_id'],
                'questions' => json_encode($aQuizQuestions),
            );
            $this->db->insert('quiz_questions', $QuizQuestions);
            unset($_SESSION['quiz_id']);
        }
    }
    // function edit($aData)
    // {
    //     $status = isset($aData['timerStatus']) ? TRUE : FALSE;
    //     $aQuiz = array(
    //         'branch_id' => $this->application_model->get_branch_id(),
    //         'title' => $aData['title'],
    //         'class_id' => $aData['class_id'],
    //         'section_id' => json_encode($aData['section_id']),
    //         'session_id' => get_session_id(),
    //         'subject_id' => $aData['subject_id'],
    //         'created_by' => get_loggedin_user_id(),
    //         'create_date' => date("Y-m-d"),
    //         'status' => $status,
    //         'total_marks' => $aData['total_marks'],
    //         'quiz_time' => $aData['quiz_time'],
    //         'publish_date' => date("Y-m-d", strtotime($aData['publish_date'])),
    //         'expire_date' => date("Y-m-d", strtotime($aData['expire_date'])),
    //         'start_time' => date("H:i", strtotime($aData['time_start'])),
    //         'end_time' => date("H:i", strtotime($aData['time_end'])),
    //     );
    //     if ($status == TRUE) {
    //         $aQuiz['timer_minutes'] = $aData['timer'];
    //     } else {
    //         $aQuiz['timer_minutes'] = null;
    //     }
    //     $this->db->where('id', $aData['quiz_id']);
    //     $this->db->update('quiz', $aQuiz);
    // }
    public function getList($classID, $branchID)
    {
        $this->db->select('quiz.*,subject.name as subject_name,class.name as class_name,section.name as section_name,staff.name as creator_name');
        $this->db->from('quiz');
        $this->db->join('subject', 'subject.id = quiz.subject_id', 'left');
        $this->db->join('quiz_questions', 'quiz_questions.quiz_id = quiz.id', 'right');
        $this->db->join('class', 'class.id = quiz.class_id', 'left');
        $this->db->join('section', 'section.id = quiz.section_id', 'left');
        $this->db->join('staff', 'staff.id = quiz.created_by', 'left');
        $this->db->where('quiz.class_id', $classID);
        $this->db->where('quiz.branch_id', $branchID);
        $this->db->where('quiz.session_id', get_session_id());
        $this->db->order_by('quiz.id', 'desc');
        $result = $this->db->get()->result_array();
        foreach ($result as $key => $value) {
            $result[$key]['section_details'] = $this->getSectionDetails($value['section_id']);
        }
        return $result;
    }
    function getSectionDetails($data)
    {
        $array = json_decode($data, true);
        $nameList = '';
        if (json_last_error() == JSON_ERROR_NONE) {
            foreach ($array as $key => $value) {
                $nameList .= get_type_name_by_id('section', $value) . '<br>';
            }
        }
        return $nameList;
    }
    public function getEvaluateList($quizID)
    {
        $quiz_student_IDs = $this->db->select('id')->where(array('quiz_id' => $quizID))->get('quiz_student')->result_array();
        if ($quiz_student_IDs) {
            $this->db->select('quiz.*,CONCAT(s.first_name, " ",s.last_name) as fullname,sh.id as quiz_student_id,s.register_no,e.student_id,sh.id as file_id, e.roll,e.section_id,sec.name as sname,subject.name as subject_name,class.name as class_name,he.id as ev_id,he.remark as ev_remarks,he.marks');
            $this->db->from('quiz');
            $this->db->join('enroll as e', 'e.class_id=quiz.class_id and quiz.section_id LIKE CONCAT(\'%"\', e.section_id, \'"%\') and e.session_id = quiz.session_id', 'inner');
            $this->db->join('student as s', 'e.student_id = s.id', 'inner');
            $this->db->join('quiz_evaluation as he', 'he.quiz_id = quiz.id and he.student_id = e.student_id', 'left');
            $this->db->join('subject', 'subject.id = quiz.subject_id', 'left');
            $this->db->join('class', 'class.id = quiz.class_id', 'left');
            $this->db->join('section as sec', 'sec.id = e.section_id', 'left');
            $this->db->join('quiz_student as sh', 's.id = sh.student_id', 'left');
            // $this->db->join('s', 'sh.student_id = s.id', 'inner');
            $this->db->where('quiz.id', $quizID);
            if (!is_superadmin_loggedin()) {
                $this->db->where('quiz.branch_id', get_loggedin_branch_id());
            }
            $this->db->where('quiz.session_id', get_session_id());
            $this->db->where_in('sh.id', array_column($quiz_student_IDs, 'id'));
            $this->db->group_by(`e` . `student_id`);
            $this->db->order_by('quiz.id', 'desc');
            // $this->db->get_compiled_select(); //$this->db->get()->result_array();
            $result = $this->db->get()->result_array();
            return $result;
        }
    }
    function getSubmittedQuiz($id)
    {
        $this->db->select('*');
        $this->db->from('quiz_questions');
        $this->db->where('quiz_id', $id);
        $aQuizQuestions = $this->db->get()->result_array();
        


        $aQuizQuestions[0]['questions'] = json_decode($aQuizQuestions[0]['questions'], true);
        $aQuizQuestions = $aQuizQuestions[0];
       

        $this->db->select('*');
        $this->db->from('quiz_student');
        $this->db->where('quiz_id', $id);
        $aQuizAnswers = $this->db->get()->result_array();
        $aQuizAnswers[0]['answer'] = json_decode($aQuizAnswers[0]['answer'], true);
        $aQuizAnswers = $aQuizAnswers[0];
        
        if (sizeof($aQuizQuestions['questions']) != sizeof($aQuizAnswers)) {

            foreach ($aQuizQuestions['questions'] as $k => $v) {

                // echo $k;
                $aQuizAnswers['answer'][$k]['selectQuestionType'] = $aQuizQuestions['questions'][$k]['selectQuestionType'];
                
                if (array_key_exists($k, $aQuizAnswers['answer'])) {
                    if (!array_key_exists('answer', $aQuizAnswers['answer'][$k])) {
                        $aQuizAnswers['answer'][$k]['answer'] = 'not attempted';
                    }
                }
                // 
                if (!array_key_exists($k, $aQuizAnswers['answer'])) {
                    $aQuizAnswers['answer'][$k]['type'] = $aQuizQuestions['questions'][$k]['type'];
                    $aQuizAnswers['answer'][$k]['answer'] = 'not attempted';
                }
            }
        }
     
        foreach ($aQuizAnswers['answer'] as $k => $v) {
            if ($v['type'] == 'mcqs' || $v['type'] == 't/f' || $v['type'] == 'f/b') {
                if ($v['type'] == 'f/b') {
                    $v['answer'] = trim($v['answer']);
                }
                if ($aQuizQuestions['questions'][$k]['answer'] == $v['answer']) {
                    $aQuizAnswers['answer'][$k]['result'] = true;
                } else {
                    $aQuizAnswers['answer'][$k]['result'] = false;
                }
            }
        }
        $result = array();
        foreach ($aQuizAnswers as $k => $v) {
            if (is_array($v)) {
                foreach ($v as $k2 => $v2) {
                    $result[$k2]['type'] = $aQuizAnswers['answer'][$k2]['type'];
                    $result[$k2]['selectQuestionType']=$aQuizAnswers['answer'][$k2]['selectQuestionType'];


                    $result[$k2]['question'] = $aQuizQuestions['questions'][$k2]['question'];
                    $result[$k2]['answer'] = $aQuizAnswers['answer'][$k2]['answer'];
                    if ($result[$k2]['type'] == 'mcqs' || $result[$k2]['type'] == 'f/b' || $result[$k2]['type'] == 't/f') {
                        $result[$k2]['result'] = $aQuizAnswers['answer'][$k2]['result'];
                        if ($result[$k2]['type'] == 'mcqs') {
                            $result[$k2]['option'] = $aQuizQuestions['questions'][$k2]['option'];
                        }
                    }
                }
            }
        }
        // echo '<pre>';
        // print_r($result);
        // echo '</pre>';
        // die();
        return $result;
    }
}
