<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class DB_update_model extends MY_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function csvImport($row)
    {
        $aBranch = $this->db->select('id')
            ->from('branch')
            ->where(array('name' => $row['campus']))
            ->get()
            ->result_array();
        $branchID =  $aBranch[0]['id'];
        $aClassMontessori= array(
            'BLUE',
            'GREEN',
            'PLAY GROUP',
            'RED' 
        );
        if($row['board'] == null && !in_array($row['class'], $aClassMontessori) ){
            $row['board'] = 'MATRICULATION';
        }
        if ($row['board'] != null) {
            if ($row['board'] == 'MATRICULATION') {
                $studentClass = $row['class'] . 'm';
            }
            if ($row['board'] == 'O LEVELS') {
                $studentClass = $row['class'] . 'o';
            }
        } else {
            $studentClass = $row['class'];
        }
        $aStatus = array(
            'Y' => 1,
            'B' => 0,
            'N' => 2
        );
        $aClass = array(
            'BLUE' => 'Blue',
            'GREEN' => 'Green',
            'PLAY GROUP' => 'Play Group',
            'RED' => 'Red',
            '1m' => 'One',
            '2m' => 'Two',
            '3m' => 'Three',
            '4m' => 'Four',
            '5m' => 'Five',
            '6m' => 'Six (M)',
            '6o' => 'Six (O/L)',
            '7m' => 'Seven (M)',
            '7o' => 'Seven (O/L)',
            '8m' => 'Eight (M)',
            '8o' => 'Eight (O/L)',
            '9m' => 'Nine (M)',
            '9o' => 'Nine (O/L)',
            '10m' => 'Ten (M)',
            '10o' => 'Ten (O/L)',
            '11o' => 'Eleven (O/L)'
        );

        $studentRecord = $this->db->select('*')
            ->where(array('register_no' => $row['Roll']))
            ->get('student')->row_array();



        $aStudent = array(
            'first_name' => $row['FirstName'],
            'last_name' => $row['LastName'],
            'gender' => $row['Gender'],
            'religion' => $row['Religion'],
            'caste' => $row['Caste'],
            'blood_group' => $row['BloodGroup'],
            'mother_tongue' => $row['MotherTongue'],
            'current_address' => $row['PresentAddress'],
            'permanent_address' => $row['PermanentAddress'],
            'city' => $row['City'],
            'state' => $row['State'],
            'mobileno' => $row['Phone'],
            'email' => $row['StudentEmail'],
            'birthday' => date("Y-m-d", strtotime($row['Birthday'])),
        );

        

        if ($studentRecord) {
            $this->db->where('register_no', $row['Roll']);
            $this->db->update('student', $aStudent);


            $class = $this->class($aClass[$studentClass]);
            $section = $this->section($row['section'], $branchID);
            // die();
            $aEnroll = array(
                'class_id' => $class,
                'section_id' => $section,
                'branch_id' => $branchID
            );

            $enrollRecord = $this->db->select('*')
            ->where(array('roll' => $row['Roll']))
            ->get('enroll')->row_array();

            if($enrollRecord){
                $this->db->where('roll', $row['Roll']);
                $this->db->update('enroll', $aEnroll);
            }else{
                $aEnroll['student_id'] = $studentRecord['id'];
                $aEnroll['roll'] = $row['Roll'];
                $aEnroll['session_id'] = get_session_id();

                $this->db->insert('enroll', $aEnroll);
            }


            $alogin_credential = array(
                'active' => $aStatus[$row['active']],
                // 'password'  => $this->app_lib->pass_hashed($row["StudentPassword"])
                // Temporary
            );
            $this->db->where('user_id', $studentRecord['id']);
            $this->db->update('login_credential', $alogin_credential);
        } else {
            $aStudent['admission_date'] = date("Y-m-d", strtotime($row['AdmissionDate']));
            $aStudent['photo'] = 'defualt.png';
            $aStudent['register_no'] = $row['Roll'];
            $this->db->insert('student', $aStudent);
            $studentID = $this->db->insert_id();

            //save student login credential
            $alogin_credential = array(
                'username' => $row["StudentEmail"],
                'role' => 7,
                'user_id' => $studentID,
                'password' => $this->app_lib->pass_hashed($row["StudentPassword"]),
            );
            $this->db->insert('login_credential', $alogin_credential);
            $classID = $this->class($aClass[$studentClass]);
            $sectionID = $this->section($row['section'], $branchID);
            $aEnroll = array(
                'student_id' => $studentID,
                'class_id' => $classID,
                'section_id' => $sectionID,
                'branch_id' => $branchID,
                'roll' => $row['Roll'],
                'session_id' => get_session_id(),
            );
            $this->db->insert('enroll', $aEnroll);
        }
    }
    function class($name)
    {
        $aClassDb = $this->db->select('id')
            ->from('class')
            ->where(array('name' => $name))
            ->get()
            ->result_array();
        return $aClassDb[0]['id'];
    }
    function section($name, $branch)
    {
        $aSectionDb = $this->db->select('id')
            ->from('section')
            ->where(array('name' => $name, 'branch_id' => $branch))
            ->get()
            ->result_array();
        // $querry = $this->db->where(array('name' => $name, 'branch_id' => $branch))->get_compiled_select('section');
        // print_r($querry);
        return $aSectionDb[0]['id'];
    }
}
