<?php defined('BASEPATH') or exit('No direct script access allowed');
/**


 * CodeIgniter PDF Library
 *
 * Generate PDF's in your CodeIgniter applications.
 *
 * @package         CodeIgniter
 * @subpackage      Libraries
 * @category        Libraries
 * @author          Chris Harvey
 * @license         MIT License
 * @link            https://github.com/chrisnharvey/CodeIgniter-  PDF-Generator-Library



 */

require_once APPPATH . 'third_party/dompdf/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

class Pdf extends DOMPDF
{
    /**
     * Get an instance of CodeIgniter
     *
     * @access  protected
     * @return  void
     */
    protected function ci()
    {
        return get_instance();
    }

    /**
     * Load a CodeIgniter view into domPDF
     *
     * @access  public
     * @param   string  $view The view to load
     * @param   array   $data The view data
     * @return  void
     */

    public function loadView($view, $data){
        $options = new Options();
        $options->set('isHtml5ParserEnabled', true);
        $options->set('isRemoteEnabled', true);
        $dompdf = new Dompdf($options);
        $data['vouchers'] = $data;
        $html = '';
        $html .= $this->ci()->load->view($view, $data, TRUE);
        $html = preg_replace('/>\s+</', "><", $html);
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'landscape');
        $dompdf->render();
        $dompdf->stream('print-vouchers.pdf', ["Attachment" => 0]);
        exit(0);
    }

    public function load_view($view, $data = array(), $all = false)
    {
        $options = new Options();
        $options->set('isHtml5ParserEnabled', true);
        $options->set('isRemoteEnabled', true);
        $dompdf = new Dompdf($options);
        $html = '';
        $aPdf = [];
        // for ($i=0; $i < 5; $i++) { 
        // $aPdf['aVocherData'] = $data[$i];

        // }
        if (isset($all['action'])) {
            if ($all['action'] == 'html') {
                // foreach ($data as $k => $v) {
                // print_r($)
                for ($i = 0; $i < 3; $i++) {
                    // $aPdf['aVocherData'] =  $v;
                    $aPdf['aVocherData'] = $data[$i];
                    // $aPdf['aVocherData'] =  $this->oFT($v);
                    $html .= $this->ci()->load->view($view, $aPdf, TRUE);
                }
                if (file_exists(FCPATH . 'r.html')) {
                    unlink(FCPATH . 'r.html');
                }
                file_put_contents('r.html', $html);
                return [
                    'success' => true,
                    'req' => 'render'
                ];
            } else if ($all['action'] == 'render') {
                ini_set('memory_limit', -1);
                set_time_limit(0);
                $html = file_get_contents(FCPATH . 'r.html');
                $dompdf->loadHtml($html);
                // (Optional) Setup the paper size and orientation
                $dompdf->setPaper('A4', 'landscape');
                // unlink(FCPATH . 'r.html');
                $dompdf->render();
                file_put_contents('tfs.pdf', $dompdf->output());
                return [
                    'success' => true,
                ];
                // $dompdf->stream("TFS-School.pdf", array("Attachment" => 0));
            }
        } else {
            $aPdf['aVocherData'] =  $data[0];
            $html .= $this->ci()->load->view($view, $aPdf, TRUE);
            $html = preg_replace('/>\s+</', "><", $html);
            $dompdf->loadHTML($html);
            // (Optional) Setup the paper size and orientation
            $dompdf->setPaper('A4', 'landscape');
            $dompdf->set_option('isRemoteEnabled', TRUE);
            // Render the HTML as PDF
            $dompdf->render();
            // print_r($html);
            // die();
            $dompdf->stream("TFS-" . $data[0]['gr_no'] . '.pdf', array("Attachment" => 0));
        }
        exit(0);
    }
    private function oFT(array $a = []) //optimizeFeeTitle
    {
        $aTitle = json_decode($a['title']);
        $aAmount = json_decode($a['amount']);
        $aMonthFee = [];
        $aAdditionalFee = [];
        $tuitionFeeCharge = 0;
        foreach ($aTitle as $k => $v) {
            if (strpos($v, 'TUITION FEE') !== false) {
                if ($k == 0) {
                    $aMonthFee[0] = str_replace('TUITION FEE', '', $v);
                } else {
                    $aMonthFee[1] = str_replace('TUITION FEE', '', $v);
                }
                $tuitionFeeCharge = intval($tuitionFeeCharge) + intval($aAmount[$k]);
                unset($aTitle[$k]);
                unset($aAmount[$k]);
            } else {
                $aAdditionalFee[] = $v;
            }
        }
        $title = 'TUITION FEE' . $aMonthFee[0] . '-' . $aMonthFee[1];
        array_unshift($aTitle, $title);
        array_unshift($aAmount, $tuitionFeeCharge);
        $aRet = [
            'title' =>   json_encode($aTitle),
            'amount' =>   json_encode($aAmount)
        ];
        return array_replace_recursive($a, $aRet);
        // echo '<pre>';
        // print_r($a);
        // die();
    }
}
