<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @package : Ramom school management system
 * @version : 2.0
 * @developed by : RamomCoder
 * @support : ramomcoder@yahoo.com
 * @author url : http://codecanyon.net/user/RamomCoder
 * @filename : Accounting.php
 * @copyright : Reserved RamomCoders Team
 */

class Vouchers extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->helpers('download');
        $this->load->model('vouchers_model');
    }

    public function index()
    {
        if (!get_permission('vouchers', 'is_view')) {
            access_denied();
        }

        // $this->data['branches'] = $this->app_lib->getRecordbyTable('branch', ['name AS id', 'name']);
        // $this->data['classes'] = $this->app_lib->getClassesbyVoucher();

        $this->data['sub_page'] = 'vouchers/index';
        $this->data['main_menu'] = 'settings';
        $this->data['title'] = translate('Vouchers');
        $this->data['headerelements'] = array(
            'css' => array(
                'vendor/dropify/css/dropify.min.css',
            ),
            'js' => array(
                'vendor/dropify/js/dropify.min.js',
            ),
        );
        $this->load->view('layout/index', $this->data);
    }

    public function update_file()
    {
        if (!get_permission('vouchers', 'is_add')) {
            ajax_access_denied();
        }
        $err_msg = "";
        $i = 0;
        $this->load->library('csvimport');
        if (isset($_FILES["voucherFile"]) && !empty($_FILES['voucherFile']['name'])) {
            $csv_array = $this->csvimport->get_array($_FILES["voucherFile"]["tmp_name"]);
            if ($csv_array) {
                $columnHeaders = array('GR#',	'Voucher#',	'Issue Date',	'Due Date',	'Valid Upto',	'Fee Month',	'Name',	'Father Name',	'Class',	'Campus Id',	 'Campus Name',	'Session'	,'Fee Detail',	'Month',	'Fee Type',	'Amount'
            );
                $csvData = array();
                $this->vouchers_model->truncateTable(); 
                foreach ($csv_array as $row) {
                    if ($i == 0) {
                        $csvData = array_keys($row);
                    }
                    $csv_chk = array_diff($columnHeaders, $csvData);
                    if (count($csv_chk) <= 0) {
                        $this->vouchers_model->csvImport($row);
                        $i++;
                    } 
                    // else {
                    //     set_alert('error', translate('invalid_csv_file'));
                    //     redirect(base_url("student/csv_import"));
                    // }
                }
                if ($err_msg != null) {
                    $this->session->set_flashdata('csvimport', $err_msg);
                }
                if ($i > 0) {
                    set_alert('success', $i . ' Recored has Been Updated');
                }
                set_alert('success', "Inserted Successfully");
                $array  = array('status' => 'success',);
            }
        } else {
            $error = $this->form_validation->error_array();
            $array = array('status' => 'fail', 'error' => $error);
        }
        echo json_encode($array);
    }

    public function print(){
        $this->load->model('userrole_model');
        $aVocherData['aVocherData'] = $this->userrole_model->getVocherList($_POST['gr_no']);

        $aData = $aVocherData['aVocherData'][0];
        $code = '';
        if ($aData['campus'] == 'MONTESSORI') {
            $code .= '71';
        } else {
            $code .= '72';
        }
        $code .= sprintf("%05d", $aData['voucher_no']);
        $code .= sprintf("%04d", $aData['gr_no']);
        $code .= sprintf("%05d", $aData['total']);
        $code .= dateConversion($aData['due_date']);
        $code .= sprintf("%05d", ($aData['total'] + 300));
        $code .= dateConversion($aData['valid_date']);

        $aVocherData['aVocherData'][0]['barcode'] = generateBarcode($code);
        $this->load->library('pdf');
        $this->pdf->load_view('voucher/index-mezn', $aVocherData['aVocherData']);
    }

}
