<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @package : Ramom school management system
 * @version : 2.0
 * @developed by : RamomCoder
 * @support : ramomcoder@yahoo.com
 * @author url : http://codecanyon.net/user/RamomCoder
 * @filename : Accounting.php
 * @copyright : Reserved RamomCoders Team
 */

class Voucher_update extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->helpers('download');
        $this->load->model('DB_update_model');
        $this->load->library(array('zip'));
    }

    public function index()
    {
        if (!get_permission('voucher_update', 'is_view')) {
            access_denied();
        }
        $dirpath = FCPATH . "uploads/vouchers/";
        $aDirFiles = scandir($dirpath);
        $this->data['aDirFiles'] = $aDirFiles;
        // $index= 0;
        // print_r($aDirFiles);
        $this->data['sub_page'] = 'voucher_update/index';
        $this->data['main_menu'] = 'settings';
        $this->data['title'] = translate('voucher_update');
        // $this->data['headerelements'] = array(
        //     'css' => array(
        //         'vendor/dropify/css/dropify.min.css',
        //     ),
        //     'js' => array(
        //         'vendor/dropify/js/dropify.min.js',
        //     ),
        // );
        $this->load->view('layout/index', $this->data);
    }

    public function update_voucher_update()
    {
        if (!get_permission('update', 'is_add')) {
            ajax_access_denied();
        }
        // $this->form_validation->set_rules('userfile', translate('attachment'), 'callback_handle_upload');
        $this->form_validation->set_rules('file_name', translate('File Name'), 'required');
        if ($this->form_validation->run() !== false) {
            $post = $this->input->post();
            $filename = $post["file_name"];
            $extractpath = FCPATH . "uploads/vouchers/";
            $filepath = $extractpath . $filename;
            if (file_exists($filepath)) {
                $_SESSION['time'] = microtime(true);
                // $config['upload_path']          = 'uploads/vouchers/';
                // $config['allowed_types']        = 'zip';
                //     $this->upload->initialize($config);
                //     foreach (new DirectoryIterator($config['upload_path']) as $k => $v) {
                //         if ($v!='index.html' && $v != '.' && $v != '..') {
                //             if (is_dir($v->getPathname())) {
                //                 foreach (new DirectoryIterator($v->getPathname()) as $key => $value){
                //                     unlink($value->getPathname());
                //                 }
                //                 rmdir($v->getPathname());
                //             }else{
                //                 unlink($v->getPathname());
                //             }
                //         }
                //     }
                //     $this->load->library('upload', $config);
                //     $this->upload->do_upload('userfile');
                //     $uploadData = $this->upload->data();
                $aDirFiles = scandir($extractpath);
                foreach ($aDirFiles as $k => $v) {
                    if ($v != '.' && $v != '..' && $v != 'desktop.ini' && $v != $filename) {
                        if (is_dir($extractpath . $v)) {
                            $subDirPath = FCPATH . "uploads/vouchers/" . $v . "/";
                            $aSubDirFiles = scandir($subDirPath);
                            foreach ($aSubDirFiles as $k2 => $v2) {
                                unlink($subDirPath . $v2);
                            }
                            rmdir($subDirPath);
                        } else {
                            unlink($extractpath . $v);
                        }
                        // echo $v . "<br>";
                    }
                }
                // $file = FCPATH . $config['upload_path'] . $uploadData['file_name'];
                // $fname = $uploadData['file_name'];
                $zip = new ZipArchive;
                $res = $zip->open($filepath);
                if ($res === TRUE) {
                    // Extract file
                    $zip->extractTo($extractpath);
                    $zip->close();
                    unlink($filepath);
                }
                $upload_time =  microtime(true) - $_SESSION['time'];
                $time = round($upload_time, 3) . 's';
                set_alert('success', "fee vouchers update Successfully");
                $array  = array('status' => 'success');
            } else {
                set_alert('error', "no sunch file exisit");
                $array = array('status' => 'fail');
            }
        } else {
            $error = $this->form_validation->error_array();
            $array = array('status' => 'fail', 'error' => $error);
        }
        echo json_encode($array);
    }
    // upload file form validation
    public function handle_upload()
    {
        if (isset($_FILES["userfile"]) && !empty($_FILES['userfile']['name'])) {
            $file_type = $_FILES["userfile"]['type'];
            $file_size = $_FILES["userfile"]["size"];
            $file_name = $_FILES["userfile"]["name"];
            $allowedExts = array('zip');
            // $upload_size = 2097152;
            $extension = pathinfo($file_name, PATHINFO_EXTENSION);
            if ($files = filesize($_FILES['userfile']['tmp_name'])) {
                if (!in_array(strtolower($extension), $allowedExts)) {
                    $this->form_validation->set_message('handle_upload', translate('this_file_type_is_not_allowed'));
                    return false;
                }
            } else {
                $this->form_validation->set_message('handle_upload', translate('error_reading_the_file'));
                return false;
            }
            return true;
        } else {
            $this->form_validation->set_message('handle_upload', "The Attachment field is required.");
            return false;
        }
    }
}
