<?php

use Sabberworm\CSS\Rule\Rule;

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @package : Ramom school management system
 * @version : 2.0
 * @developed by : RamomCoder
 * @support : ramomcoder@yahoo.com
 * @author url : http://codecanyon.net/user/RamomCoder
 * @filename : video.php
 * @copyright : Reserved RamomCoders Team
 */

class Quiz extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('quiz_model');
        $this->load->model('sms_model');
    }

    public function index()
    {
        // check access permission
        if (!get_permission('quiz', 'is_view')) {
            access_denied();
        }

        $branchID = $this->application_model->get_branch_id();
        if ($_POST) {
            $classID = $this->input->post('class_id');
            // $sectionID = $this->input->post('section_id');
            $subjectID = $this->input->post('subject_id');
            $this->data['quizlist'] = $this->quiz_model->getList($classID, $branchID);
        }

        $this->data['branch_id'] = $branchID;
        $this->data['title'] = translate('quiz');
        $this->data['sub_page'] = 'quiz/index';
        $this->data['main_menu'] = 'quiz';
        $this->load->view('layout/index', $this->data);
    }

    public function add()
    {
        if (!get_permission('quiz', 'is_add')) {
            access_denied();
        }
        if ($_POST) {
        
            if ($this->input->post('step') == 'step1') {
                // echo 'step1';
                if ($_POST['setting']['timer']) {   
                    $this->form_validation->set_rules('quiz_time', translate('quiz_time'), 'required');
                }
                $this->quiz_detail_validation();
                if ($this->form_validation->run() !== false) {
                    $aPost = $this->input->post();
                    $aStep1 = array(
                        'step' => $aPost['step'],
                        'class_id' => $aPost['class_id'],
                        'section_id' => $aPost['section_id'],
                        'subject_id' => $aPost['subject_id'],
                        'total_marks' => $aPost['total_marks'],
                        'quiz_time' => $aPost['quiz_time'],
                        'title' => $aPost['title'],
                        'setting' => $aPost['setting'],
                        'publish_date' => $aPost['publish_date'],
                        'expire_date' => $aPost['expire_date'],
                        'time_start' => $aPost['time_start'],
                        'time_end' => $aPost['time_end'],
                    );
                    if (is_superadmin_loggedin()) {
                        $aStep1['branch_id'] = $aPost['branch_id'];
                    }
                    $this->quiz_model->save($aStep1);
                } else {
                    $error = $this->form_validation->error_array();
                    $array = array('status' => 'fail', 'error' => $error);
                }
            }
            if ($this->input->post('step') == 'step2') {
                $aData = $this->input->post();
                $aFiles=$_FILES;
                
                foreach ($aData as $k => $v) {
                    $this->quiz_question_validation($k, $v);
                }

                foreach ($aData as $key => $value) {
                    if ($key !== 'step') {
                        $selectQuestionType = $value['selectQuestionType'];
                        if($selectQuestionType=='image')
                        {
                            $image_path='assets/questions_images';

                            if (!file_exists($image_path)) {
                                // echo "no directory";
                                mkdir($image_path, 0777);
                            }
                            $file_path=$this->do_upload($aFiles[$key],$image_path,$key);
                          
                            $aData[$key]['question']=$file_path;
                        }
                    }
                }
                
                if ($this->form_validation->run() !== false) {
                    $this->quiz_model->save($aData);

                        $this->load->library('upload');
                    set_alert('success', translate('information_has_been_saved_successfully'));
                    $url = base_url('quiz');
                    $array = array('status' => 'success', 'url' => $url);
                } else {
                    $error = $this->form_validation->error_array();
                    $array = array('status' => 'fail', 'error' => $error);
                }
            }
            echo json_encode($array);
            exit();
        }

        $this->data['branch_id'] = $this->application_model->get_branch_id();
        $this->data['title'] = translate('Quiz');
        $this->data['sub_page'] = 'quiz/add';
        $this->data['main_menu'] = 'quiz';
        $this->data['headerelements'] = array(
            'css' => array(
                'vendor/summernote/summernote.css',
                'vendor/bootstrap-timepicker/css/bootstrap-timepicker.css',
            ),
            'js' => array(
                'vendor/summernote/summernote.js',
                'vendor/bootstrap-timepicker/bootstrap-timepicker.js',
            ),
        );
        $this->load->view('layout/index', $this->data);
    }
    public function edit($id = '')
    {
        if (!get_permission('quiz', 'is_edit')) {
            access_denied();
        }

        if ($_POST) {
            $this->quiz_detail_validation();
            if ($_POST['setting']['timer']) {
                $this->form_validation->set_rules('quiz_time', translate('quiz_time'), 'required');
            }
            if ($this->form_validation->run() !== false) {
                $post = $this->input->post();
                $response = $this->quiz_model->save($post);
                set_alert('success', translate('information_has_been_updated_successfully'));
                $url = base_url('quiz');
                $array = array('status' => 'success', 'url' => $url);
            } else {
                $error = $this->form_validation->error_array();
                $array = array('status' => 'fail', 'error' => $error);
            }
            echo json_encode($array);
            exit();
        }

        $this->data['quiz'] = $this->app_lib->getTable('quiz', array('t.id' => $id), true);
        $this->data['quiz']['quiz_setting'] = json_decode($this->data['quiz']['quiz_setting'],true);
        $this->data['branch_id'] = $this->application_model->get_branch_id();;
        $this->data['title'] = translate('quiz');
        $this->data['sub_page'] = 'quiz/edit';
        $this->data['main_menu'] = 'quiz';
        $this->data['headerelements'] = array(
            'css' => array(
                'vendor/summernote/summernote.css',
                'vendor/bootstrap-fileupload/bootstrap-fileupload.min.css',
                'vendor/bootstrap-timepicker/css/bootstrap-timepicker.css',
            ),
            'js' => array(
                'vendor/summernote/summernote.js',
                'vendor/bootstrap-fileupload/bootstrap-fileupload.min.js',
                'vendor/bootstrap-timepicker/bootstrap-timepicker.js',
            ),
        );
        $this->load->view('layout/index', $this->data);
    }
    public function QuizModal()
    {
        if (get_permission('quiz', 'is_add')) {
            echo $this->load->view('quiz/quizModal', $this->data, true);
        }
    }
    public function quizTypeModel()
    {
        if (get_permission('quiz', 'is_add')) {
            echo $this->load->view('quiz/quizTypeModel', $this->data, true);
        }
    }
    public function delete($id = '')
    {
        if (get_permission('quiz', 'is_delete') && !empty($id)) {
            if (!is_superadmin_loggedin()) {
                $this->db->where('branch_id', get_loggedin_branch_id());
            }
            $this->db->where('quiz_id', $id);
            $this->db->delete('quiz_questions');
            $this->db->where('id', $id);
            $this->db->delete('quiz');
        }
    }
    public function evaluate($id = '')
    {
        // check access permission
        if (!get_permission('quiz', 'is_edit')) {
            access_denied();
        }

        $branchID = $this->application_model->get_branch_id();
        $this->data['quizlist'] = $this->quiz_model->getEvaluateList($id);
        $this->data['branch_id'] = $branchID;
        $this->data['title'] = translate('quiz');
        $this->data['sub_page'] = 'quiz/evaluate_list';
        $this->data['main_menu'] = 'quiz';

        $this->data['headerelements'] = array(
            'css' => array(
                'vendor/summernote/summernote.css',
            ),
            'js' => array(
                'vendor/summernote/summernote.js',
            ),
        );
        $this->load->view('layout/index', $this->data);
    }
    function studentQuizModal()
    {
        $this->data['studentquiz'] = $this->quiz_model->getSubmittedQuiz($this->input->post('quiz_id'));
        echo $this->load->view('quiz/studentQuizModal', $this->data, true);
    }
    function evaluate_save()
    {
        // check access permission
        if (!get_permission('quiz_evaluate', 'is_add')) {
            ajax_access_denied();
        }
        if ($_POST) {
            $this->form_validation->set_rules('date', translate('date'), 'trim|required');
            if ($this->form_validation->run() !== false) {
                $evaluate = $this->input->post('evaluate');
                $quizID = $this->input->post('quiz_id');
                $date = date("Y-m-d", strtotime($this->input->post('date')));
                foreach ($evaluate as $key => $value) {
                    $arrayAttendance = array(
                        'quiz_id' => $quizID,
                        'student_id' => $value['student_id'],
                        'marks' => $value['marks'],
                        'remark' => $value['remark'],
                        'date' => $date,
                    );
                    if (empty($value['evaluation_id'])) {
                        $this->db->insert('quiz_evaluation', $arrayAttendance);
                    } else {
                        $this->db->where('id', $value['evaluation_id']);
                        $this->db->update('quiz_evaluation', array('marks' => $value['marks'], 'remark' => $value['remark'], 'date' => $date));
                    }
                }
                $this->db->where('id', $quizID);
                $this->db->update('quiz', array('evaluation_date' => $date, 'evaluated_by' => get_loggedin_user_id()));

                set_alert('success', translate('information_has_been_saved_successfully'));
                $url = base_url('quiz');
                $array  = array('status' => 'success', 'url' => $url);
            } else {
                $error = $this->form_validation->error_array();
                $array = array('status' => 'fail', 'error' => $error);
            }
            echo json_encode($array);
            exit();
        }
    }

    public function evaluateModal()
    {
        $this->data['quizID'] = $this->input->post('quiz_id');
        echo $this->load->view('quiz/evaluateModal', $this->data, true);
    }
    public function delete_data($id = '', $ev_id = '')
    {
        $this->db->where('id', $id);
        $this->db->delete('quiz_student');
        $this->db->where('id', $ev_id);
        $this->db->delete('quiz_evaluation');
    }
    /* quiz form validation rules */
    protected function quiz_detail_validation()
    {
        if (is_superadmin_loggedin()) {
            $this->form_validation->set_rules('branch_id', translate('branch'), 'required');
        }
        $this->form_validation->set_rules('class_id', translate('class'), 'trim|required');
        $this->form_validation->set_rules('section_id[]', translate('section'), 'trim|required');
        $this->form_validation->set_rules('subject_id', translate('subject'), 'trim|required');
        $this->form_validation->set_rules('title', translate('title'), 'trim|required');
        $this->form_validation->set_rules('time_start', translate('time_start'), 'trim|required');
        $this->form_validation->set_rules('time_end', translate('time_end'), 'trim|required');
        $this->form_validation->set_rules('publish_date', translate('publish_date'), 'required');
        $this->form_validation->set_rules('expire_date', translate('expire_date'), 'required');
        $this->form_validation->set_rules('total_marks', translate('total_marks'), 'required');
        if (isset($_POST['timerStatus'])) {
            $this->form_validation->set_rules('timer', translate('timer_minutes'), 'trim|required');
        }
    }

    function quiz_question_validation($question, $aValid)
    {
        foreach ($aValid as $k => $v) {
            if (is_array($v)) {
                foreach ($v as $k2 => $v2) {
                    $this->form_validation->set_rules($question . '[' . $k . ']' . '[' . $k2 . ']', translate($question . ' ' . $k . ' ' . $k2), 'trim|required');
                }
            } else {
                $this->form_validation->set_rules($question . '[' . $k . ']', translate($question . ' ' . $k), 'trim|required');
            }
        }
    }

    function do_upload($filename,$file_path,$field_name)
    {
        
        $file_name= date("Y_m_d")."_".time()."_".rand();
        $file_extention=".".pathinfo($filename['name'],PATHINFO_EXTENSION);
        $full_file_path=$file_path."/".$file_name.$file_extention;

        // $config['upload_path']          =  $file_path;
        // $config['allowed_types']        = 'gif|jpg|png';
        // $config['max_size']             = 100;
        // $config['max_width']            = 1024;
        // $config['max_height']           = 768;

        $this->load->library('upload', $config);

        if (move_uploaded_file($filename['tmp_name'], $full_file_path)) {
            return $full_file_path;
        } else {
            echo "File not uploaded";
        }

    }


}
