<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @package : Ramom school management system
 * @version : 2.0
 * @developed by : RamomCoder
 * @support : ramomcoder@yahoo.com
 * @author url : http://codecanyon.net/user/RamomCoder
 * @filename : Accounting.php
 * @copyright : Reserved RamomCoders Team
 */

class Database_backup extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        // $this->load->model('dashboard_model');
        // $this->load->model('userrole_model');
    }
    public function index()
    {
        redirect(base_url('dashboard'));
    }
    public function backupDb()
    {
        $tables = $this->db->list_tables();
        // $tables = $this->db->list_tables();
        ini_set('memory_limit', '10000M');
        set_time_limit(0);
        $path = FCPATH . 'assets/database_backups/';
        $lastBackupFile = $path . 'last_backup.txt';
        $dateFormat = 'd-m-y';
        $newfileName = $this->db->database . '-' . date('Y-m-d-H-i-s');
        if (!file_exists($lastBackupFile)) {
            file_put_contents($lastBackupFile, '');
        }
        $this->delOldBackup();
        $lastBackup = file_get_contents($lastBackupFile);
        if (strtotime($lastBackup) == strtotime(date($dateFormat))) {
            return false;
        }
        $this->load->dbutil();
        $prefs = array( 
            'tables'        => $tables,   // Array of tables to backup.
            // 'ignore'        => array(),
            'format' => 'zip',
            'filename' => $newfileName . '.sql',
            // 'foreign_key_checks' => true,
            // 'add_insert' => true,
            // 'newline' => "\n",
            'add_drop' => false,
            'foreign_key_checks' => false,
            'newline' => "\r\n",
            'add_insert' => true
        );
        $backup = $this->dbutil->backup($prefs);
        $db_name = $newfileName . '.zip';
        $save = $path . $db_name;
        $this->load->helper('file');
        write_file($save, $backup);
        file_put_contents($lastBackupFile, date($dateFormat));
        // $this->load->helper('download');
        // force_download($db_name, $backup);
        echo json_encode(['success' => true]);
    }

    protected function delOldBackup()
    {
        $removeBefore = 10;
        $this->load->helper('directory');
        $path = FCPATH . 'assets/database_backups/';
        $aFiles = directory_map($path);
        $beforeDate = date('Y-m-d', strtotime('-' . $removeBefore . ' days', strtotime(date('Y-m-d'))));
        foreach ($aFiles as $key => $file) {
            $ext = pathinfo($file, PATHINFO_EXTENSION);
            if ($ext == 'zip') {
                $exFile = str_replace($this->db->database . '-', '', $file);
                // print_r(explode('-', $exFile));
                $fileDate = substr($exFile, 0, 10);
                if (strtotime($beforeDate) >= strtotime($fileDate)) {
                    unlink($path . $file);
                }
            }
        }
    }
}
