<style type="text/css">
    .loader {
        border: 5px solid #3d3d3d;
        border-top: 5px solid #3498db;
        border-radius: 50%;
        width: 30px;
        height: 30px;
        animation: spin 2s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
</style>
<section class="panel">
    <div class="tabs-custom">
        <ul class="nav nav-tabs">
            <?php if (get_permission('vouchers', 'is_add')) { ?>
                <li class="active">
                    <a href="#vouchers" data-toggle="tab">
                        <i class="icon-pencil"></i> <?= translate('vouchers') ?>
                    </a>
                </li>
                <li class="">
                    <a href="#printVouchers" data-toggle="tab">
                        Print Vouchers
                    </a>
                </li>
            <?php } ?>
        </ul>
        <div class="tab-content">
            <?php if (get_permission('vouchers', 'is_add')) { ?>
                <div class="tab-pane box active" id="vouchers">
                    <!-- <?php echo form_open_multipart('vouchers/update_file', array('class' => 'form-horizontal frm-submit-data')); ?> -->
                    <div class="form-group mb-lg">
                        <label class="col-md-3 control-label"><?= translate('file_upload') ?> <span class="required" aria-required="true">*</span></label>
                        <div class="col-md-7">
                            <input type="file" id="csv_file" name="voucherFile" class="dropify" data-height="140" data-allowed-file-extensions="csv" />
                            <span class="error"></span>
                        </div>
                    </div>
                    <footer class="panel-footer">
                        <div class="row">
                            <div class="col-md-2 col-sm-offset-3">
                                <button onclick="uploadFeeVoucher()" id="uploadFeeVoucherBtn" type="submit" class="btn btn-default btn-block" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
                                    <i class="fas fa-cloud-upload-alt"></i> <?= translate('upload') ?> CSV
                                </button>
                            </div>
                            <div class="col-md-2">
                                <div class="loader hidden"></div>
                            </div>
                        </div>
                    </footer>
                    <!-- <?php echo form_close(); ?> -->
                </div>
                <div class="tab-pane box" id="printVouchers">
                    <!--<?php echo form_open_multipart('vouchers/print', ['target' => '_blank']); ?>-->
                        <div class="form-group mb-lg">
                            <!-- <label class="col-md-2 control-label">Class</label>
                            <div class="col-md-4">
                                <select class="form-control" name="class_sep" data-plugin-selectTwo data-width='100%'>
                                    <?=print_classes($classes);?>
                                </select>
                            </div> -->
                            <label class="col-md-2 control-label mt-2">GR # <span class="required" aria-required="true">*</span></label>
                            <div class="col-md-4">
                                <input type="text" name="gr_no" class="form-control" id="pv_gr_no">
                            </div>
                        </div>
                        <footer class="panel-footer">
                            <div class="row">
                                <div class="col-md-2 col-sm-offset-3">
                                    <button type="submit" class="btn btn-success btn-block" onclick="printVoucher()">
                                        <i class="fas fa-cloud-upload-alt"></i> Print</button>
                                </div>
                            </div>
                        </footer>
                    <!--<?php echo form_close(); ?>-->
                </div>
            <?php } ?>
        </div>
    </div>
</section>
<script>
    function printVoucher(){
        var gr_no = $('#pv_gr_no').val();
        if(gr_no){
            var url = 'https://result.tfs.education/fee-voucher/'+gr_no;
            window.open(url);   
        }else{
            alert('Please Enter GR #');
        }
    }

    function uploadFeeVoucher(){
        uploading(true);
        var csv_file = $('#csv_file')[0].files[0];
        if(csv_file){
            var fd = new FormData();
            fd.append('csv_file', csv_file);
            $.ajax({
                url: 'https://result.tfs.education/api/upload-fee-vouchers',
                type: 'POST',
                dataType: 'JSON',
                processData: false,
                contentType: false,
                data: fd,
                success: function(r) {
                    var res = JSON.parse(JSON.stringify(r));
                    alert(res.message);
                    uploading(false);
                    $('.dropify-clear').click();
                },
                error: function(r) {
                    var res = JSON.parse(JSON.stringify(r));
                    alert(res.responseJSON.message);
                    uploading(false);
                }
            });
        }else{
            alert('No CSV File Found.');
            uploading(false);
        }
    }

    function uploading(flag){
        if(flag){
            $('#uploadFeeVoucherBtn').prop('disabled', true);
            $('.loader').removeClass('hidden');
        }else{
            $('#uploadFeeVoucherBtn').prop('disabled', false);
            $('.loader').addClass('hidden');
        }
    }


</script>