<div class="row">
	<div class="col-md-12">
		<section class="panel">
			<?php echo form_open_multipart($this->uri->uri_string(), array('class' => 'form-bordered form-horizontal frm-submit-data')); ?>
			<input type="hidden" name="video_id" value="<?= $video['id'] ?>">
			<header class="panel-heading">
				<h4 class="panel-title"><i class="fas fa-plus-circle"></i> <?= translate('edit') . " " . translate('video') ?></h4>
			</header>
			<div class="panel-body mb-md">
				<div class="mt-md"></div>
				<?php if (is_superadmin_loggedin()) : ?>
					<div class="form-group">
						<label class="control-label col-md-3"><?= translate('branch') ?> <span class="required">*</span></label>
						<div class="col-md-6">
							<?php
							$arrayBranch = $this->app_lib->getSelectList('branch');
							echo form_dropdown("branch_id", $arrayBranch, $video['branch_id'], "class='form-control' id='branch_id'
								data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'");
							?>
							<span class="error"></span>
						</div>
					</div>
				<?php endif; ?>
				<div class="form-group">
					<label class="col-md-3 control-label"><?= translate('class') ?> <span class="required">*</span></label>
					<div class="col-md-6">
						<?php
						
						$arrayClass = $this->app_lib->getClass($video['branch_id']);
						echo form_dropdown("class_id", $arrayClass, $video['class_id'], "class='form-control' id='class_id' onchange='getSectionByClass(this.value,0)'
						data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
						?>
						<span class="error"></span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-md-3 control-label"><?= translate('section') ?> <span class="required">*</span></label>
					<div class="col-md-6">
						<?php
						$sel = json_decode($video['section_id'], true);
						$arraySections = $this->app_lib->getSections($video['class_id'], false, true);
						echo form_dropdown("section[]", $arraySections, $sel, "class='form-control' id='section_id' data-plugin-selectTwo data-width='100%' multiple
								data-minimum-results-for-search='Infinity' ");
						?>
						<span class="error"></span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-md-3 control-label"><?= translate('subject') ?> <span class="required">*</span></label>
					<div class="col-md-6">
						<?php						
						if (!empty($video['class_id'])) {
							$arraySubject = array("" => translate('select'));
							$assigns = $this->db->select('subject_id')->from('subject_assign')->where('class_id' , $video['class_id'])->where_in('section_id' , $sel)->get()->result_array();
							foreach ($assigns as $row) {
								$arraySubject[$row['subject_id']] = get_type_name_by_id('subject', $row['subject_id']);
							}
						} else {
							$arraySubject = array("" => translate('select_class_first'));

						}
							echo form_dropdown("subject_id", $arraySubject, $video['subject_id'], "class='form-control' id='subject_id'
							data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
						?>
						<span class="error"></span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-md-3 control-label"><?= translate('url') ?> <span class="required">*</span></label>
					<div class="col-md-6">
						<input id="url" name="url" type="text" class="form-control" value="<?= $video['provided_url'] ?>">
						<span class="error"></span>
					</div>
				</div>
				
				<div class="form-group">
					<label class="col-md-3 control-label">Publish Date <span class="required">*</span></label>
					<div class="col-md-6">
						<div class="input-group">
							<span class="input-group-addon"><i class="far fa-calendar-alt"></i></span>
							<input type="text" class="form-control" name="publish_date" id="publish_date" value="<?= $video['publish_date'] ?>" autocomplete="off"  data-plugin-datepicker data-plugin-options='{ "todayHighlight" : true }' />
						</div>
						<span class="error"></span>
					</div>
				</div>				
				<div class="form-group">
					<label class="col-md-3 control-label">Expire Date <span class="required">*</span></label>
					<div class="col-md-6">
						<div class="input-group">
							<span class="input-group-addon"><i class="far fa-calendar-alt"></i></span>
							<input type="text" class="form-control" name="expire_date" id="expire_date" value="<?= $video['expire_date'] ?>" autocomplete="off"  data-plugin-datepicker data-plugin-options='{ "todayHighlight" : true }' />
						</div>
						<span class="error"></span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-md-3 control-label"><?= translate('Description') ?> <span class="required">*</span></label>
					<div class="col-md-6">
						<textarea name="description" class="summernote"><?= $video['description'] ?></textarea>
						<span class="error"></span>
					</div>
				</div>
			</div>
			<footer class="panel-footer">
				<div class="row">
					<div class="col-md-offset-3 col-md-2">
						<button type="submit" class="btn btn-default btn-block" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
							<i class="fas fa-plus-circle"></i> <?= translate('update') ?>
						</button>
					</div>
				</div>
			</footer>
			<?php echo form_close(); ?>
		</section>
	</div>
</div>

<script type="text/javascript">
	$(document).ready(function() {
		$('#branch_id').on('change', function() {
			var branchID = $(this).val();
			getClassByBranch(branchID);
			$('#subject_id').html('').append('<option value=""><?= translate("select") ?></option>');
		});
		$.ajax({
			url: base_url + 'subject/getByClassSection',
			type: 'POST',
			data: {
				classID: "<?=$video['class_id']?>",
                sectionID: <?=json_encode($video['section_id'])?>,
                subjectID: "<?=$video['subject_id']?>",
				edit : 'edit'
			},
			success: function(data) {
				console.log(data);
				$('#subject_id').html(data);
			}
		});
		$('#section_id').on('change', function() {
			var classID = $('#class_id').val();
			var sectionID = $(this).val();
			$.ajax({
				url: base_url + 'subject/getByClassSection',
				type: 'POST',
				data: {
					classID: classID,
					sectionID: sectionID,
					subjectID: <?=$video['subject_id']?>,
				},
				success: function(data) {
					$('#subject_id').html(data);
				}
			});
		});

	});
</script>