<section class="panel">
    <?php echo form_open('quiz/evaluate_save', array('class' => 'frm-submit'));
    if ($quizlist) {
        $evaDate = array_column($quizlist, 'evaluation_date');
    }
    ?>
    <input type="hidden" name="quiz_id" value="<?= $this->uri->segment(3) ?>">
    <header class="panel-heading">
        <h4 class="panel-title"><i class="fas fa-list"></i> <?= translate('student_list') ?></h4>
    </header>
    <div class="panel-body">
        <div class="row">
            <div class="col-md-3">
                <div class="form-group mb-sm">
                    <label class="control-label"><?= translate('date') ?> <span class="required">*</span></label>
                    <div class="input-group">
                        <span class="input-group-addon"><i class="far fa-calendar-alt"></i></span>
                        <input type="text" class="form-control" name="date" id="date" value="<?php $quizlist ? set_value('date', $evaDate[0]) : '' ?>" autocomplete="off" data-plugin-datepicker data-plugin-options='{ "todayHighlight" : true }' />
                    </div>
                    <span class="error"></span>
                </div>
            </div>
        </div>
        <div class="table-responsive mb-sm mt-xs">
            <table class="table table-bordered table-hover table-condensed mb-none">
                <thead>
                    <tr>
                        <th><?= translate('sl') ?></th>
                        <th><?= translate('student') ?></th>
                        <th><?= translate('register_no') ?></th>
                        <th><?= translate('class') ?></th>
                        <th><?= translate('section') ?></th>
                        <th><?= translate('subject') ?></th>
                        <th><?= translate('marks') ?></th>
                        <th><?= translate('remarks') ?></th>
                        <th><?= translate('view_quiz') ?></th>
                        <th><?= translate('delete') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $count = 1;
                    if ($quizlist) {
                        // $array = array(
                        //     1 => 1,
                        //     2 => 2,
                        //     3 => 3,
                        //     4 => 4,
                        //     5 => 5,
                        // );
                        // $total_marks = $quizlist[0]['total_marks'];
                        // for($i = 1; $i<=$total_marks;$i++){
                        //     $tarray[$i] = $i;
                        // }
                        // print_r($tarray);
                        foreach ($quizlist as $key => $row) {
                    ?>
                            <tr>
                                <input type="hidden" name="evaluate[<?= $key ?>][evaluation_id]" value="<?= $row['ev_id'] ?>">
                                <input type="hidden" name="evaluate[<?= $key ?>][student_id]" value="<?= $row['student_id'] ?>">
                                <td><?php echo $count++; ?></td>
                                <td><?php echo $row['fullname']; ?></td>
                                <td><?php echo $row['register_no']; ?></td>
                                <td><?php echo $row['class_name']; ?></td>
                                <td><?php echo $row['sname']; ?></td>
                                <td><?php echo $row['subject_name']; ?></td>
                                <td class="min-w-xs">
                                    <input style="width: 100%" class="form-control" name="evaluate[<?= $key ?>][marks]" type="number" min='0' onkeypress="return isNumeric(event)" oninput="maxLengthCheck(this)" max='<?= $row['total_marks'] ?>' placeholder="<?= translate('marks') ?>" value="<?= $row['marks'] ?>">
                                </td>
                                <td class="min-w-sm">
                                    <input style="width: 100%" class="form-control" name="evaluate[<?= $key ?>][remark]" type="text" placeholder="<?= translate('remarks') ?>" value="<?= $row['ev_remarks'] ?>">
                                </td>
                                <td>
                                    <button type="button" onclick="studentQuizModal(<?= $row['id'] ?>)" style="display: initial;" class="btn btn-default btn-circle icon" data-toggle="tooltip" data-original-title="<?= translate('quiz') ?>"><i class="far fa-arrow-alt-circle-right"></i></button>
                                </td>
                                <td>

                                    <?php echo a_delete('quiz/delete_data/' . $row['quiz_student_id'] . '/' . $row['ev_id']); ?>

                            </tr>
                    <?php
                        }
                    } else {
                        echo '<tr><td colspan="12"><h5 class="text-danger text-center">' . translate('no_information_available') . '</td></tr>';
                    } ?>
                </tbody>
            </table>
        </div>
    </div>
    <div class="panel-footer">
        <div class="row">
            <div class="col-md-offset-10 col-md-2">
                <button type="submit" class="btn btn-default btn-block" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
                    <i class="fas fa-plus-circle"></i> <?= translate('save') ?>
                </button>
            </div>
        </div>
    </div>
    <?php echo form_close(); ?>
</section>
<div class="zoom-anim-dialog modal-block modal-block-lg mfp-hide" id="modalquiz">
    <section class="panel">
        <header class="panel-heading">
            <div>
                <h4 class="panel-title" style="display: inline-block;"><i class="fas fa-canel"></i> <?php echo translate('Student') . " " . translate('Quiz'); ?></h4>
                <span class="panel-title text-right modal-dismiss close" style="float: right;"><i class="fas fa-times"></i></span>
            </div>
        </header>
        <div class="panel-body">
            <div id='quick_view_quiz'></div>
        </div>
        <footer class="panel-footer">
        </footer>
    </section>
</div>
<script>
    function studentQuizModal(id) {
        $.ajax({
            url: base_url + 'quiz/studentQuizModal',
            type: 'POST',
            data: {
                'quiz_id': id
            },
            dataType: "html",
            success: function(data) {
                $('#quick_view_quiz').html(data);
                if ($(".summernote").length) {
                    $('.summernote').summernote({
                        height: 100,
                    });
                    $('.note-toolbar').css('display', 'none');
                    $(".note-editable").attr("contenteditable", "false")
                }
                mfp_modal('#modalquiz');
            }
        });
    }

    function maxLengthCheck(object) {
        if (object.value.length > object.max.length)
            object.value = object.value.slice(0, object.max.length)
    }

    function isNumeric(evt) {
        var theEvent = evt || window.event;
        var key = theEvent.keyCode || theEvent.which;
        key = String.fromCharCode(key);
        var regex = /[0-9]|\./;
        if (!regex.test(key)) {
            theEvent.returnValue = false;
            if (theEvent.preventDefault) theEvent.preventDefault();
        }
    }
</script>