<?php 
$this->db->select('quiz.*,staff.name as creator_name');
$this->db->from('quiz');
$this->db->join('staff', 'staff.id = quiz.evaluated_by', 'left');
if (!is_superadmin_loggedin()) {
	$this->db->where('quiz.branch_id', get_loggedin_branch_id());
}
$this->db->where('quiz.id', $quizID);
$this->db->where('quiz.session_id', get_session_id());
$this->db->order_by('quiz.id', 'desc');
$row = $this->db->get()->row_array();
 ?>
<div class="row">
	<div class="col-md-8">
		<label><span class="text-weight-semibold"><?=translate('quiz')?></span></label>
		<!-- <div class="alert alert-subl text-dark"><?=$row['description']?></div> -->
	</div>
	<div class="col-md-4">
		<label><span class="text-weight-semibold"><?=translate('start_date_of_quiz')?></span> : <?=_d($row['publish_date'])?></label><br>
		<label><span class="text-weight-semibold"><?=translate('end_date_of_quiz')?></span> : <?=_d($row['expire_date'])?> </label><br>
		<label><span class="text-weight-semibold"><?=translate('evaluation_date')?></span> : <?=$row['evaluation_date'] != null ? _d($row['evaluation_date']) : "N/A";?> </label><br>
		<label><span class="text-weight-semibold"><?=translate('evaluated_by')?></span> : <?=$row['creator_name'] != null ? $row['creator_name'] : "N/A";?></label><br>
		<label><span class="text-weight-semibold"><?=translate('document')?></span> : <a href="<?=base_url('quiz/download/' . $row['id'])?>" class="mail-subj"><?=$row['document']?></a></label><br>
	<?php if ($row['status'] == 1) { ?>
		<label><span class="text-weight-semibold"><?=translate('published') . " " . translate('date')?></span> : <?=_d($row['schedule_date'])?> </label><br>
	<?php } else { ?>
		<p><a href="<?=base_url('quiz/evaluate/' . $row['id'])?>" class="mail-subj">Click To Evaluate quiz</a></p>
	<?php } ?>
	</div>
</div>