<div class="row">
    <div class="col-md-12">
        <section class="panel">
            <?php echo form_open_multipart($this->uri->uri_string(), array('class' => 'form-bordered form-horizontal frm-submit-data')); ?>
            <header class="panel-heading">
                <h4 class="panel-title"><i class="fas fa-plus-circle"></i> <?= translate('add') . " " . translate('quiz') ?></h4>
            </header>
            <div class="panel-body mb-md">
                <div class="mt-md"></div>
                <?php if (is_superadmin_loggedin()) : ?>
                    <div class="form-group">
                        <label class="control-label col-md-3"><?= translate('branch') ?> <span class="required">*</span></label>
                        <div class="col-md-6">
                            <?php
                            $arrayBranch = $this->app_lib->getSelectList('branch');
                            echo form_dropdown("branch_id", $arrayBranch, set_value('branch_id'), "class='form-control' id='branch_id'
								data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'");
                            ?>
                            <span class="error"></span>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="form-group">
                    <label class="col-md-3 control-label"><?= translate('class') ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <?php
                        $arrayClass = $this->app_lib->getClass($branch_id);
                        echo form_dropdown("class_id", $arrayClass, set_value('class_id'), "class='form-control' id='class_id' onchange='getSectionByClass(this.value,0)'
							data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
                        ?>
                        <span class="error"></span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label"><?= translate('section') ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <select class="form-control" name="section_id[]" id="section_id" data-plugin-selectTwo multiple>
                        </select>
                        <span class="error"></span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label"><?= translate('subject') ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <?php
                        if (!empty(set_value('class_id'))) {
                            $arraySubject = array("" => translate('select'));
                            $assigns = $this->db->get_where('subject_assign', array('class_id' => set_value('class_id'), 'section_id' => set_value('section_id')))->result();
                            foreach ($assigns as $row) {
                                $arraySubject[$row->subject_id] = get_type_name_by_id('subject', $row->subject_id);
                            }
                        } else {
                            $arraySubject = array("" => translate('select_class_first'));
                        }
                        echo form_dropdown("subject_id", $arraySubject, set_value('subject_id'), "class='form-control' id='subject_id'
							data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
                        ?>
                        <span class="error"></span>
                    </div>
                </div>
                <input name="step" type="hidden" class="form-control" value="step1">
                <div class="form-group">
                    <label class="col-md-3 control-label"><?= translate('title') ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <input id="title" name="title" type="text" class="form-control" value="">
                        <span class="error"></span>
                    </div>
                </div>
                <div class="form-group">
                    <div class="col-md-3">
                        <label class="col-md-12 control-label"><?= translate('quiz_setting') ?> <span class="required">*</span></label>
                    </div>
                    <div class="col-md-6">
                        <!-- timer -->
                        <div class="col-md-4">
                            <label class="col-md-12 p-0"><?= translate('timer') ?> <span class="required">*</span></label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" onclick="timerStatus(this)" value="1" name="setting[timer]" checked id="timer">
                            <label for="timer">Active</label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" value="0" onclick="timerStatus(this)" name="setting[timer]" id="timer">
                            <label for="timer">Unactive</label>
                        </div>
                        <!-- copy paste -->
                        <div class="col-md-4">
                            <label class="col-md-12 p-0"><?= translate('copy_&_paste') ?> <span class="required">*</span></label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" value="0" name="setting[cp]" checked id="cp">
                            <label for="cp">Allow</label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" value="1" name="setting[cp]" id="cp">
                            <label for="cp">Not Allow</label>
                        </div>
                        <!-- focus out -->
                        <div class="col-md-4">
                            <label class="col-md-12 p-0"><?= translate('focus_out') ?> <span class="required">*</span></label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" value="0" name="setting[focus]" checked id="focus">
                            <label for="cp">Allow</label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" value="1" name="setting[focus]" id="focus">
                            <label for="cp">Not Allow</label>
                        </div>
                        <!-- refresh -->
                        <div class="col-md-4">
                            <label class="col-md-12 p-0"><?= translate('refresh') ?> <span class="required">*</span></label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" value="0" name="setting[refresh]" checked id="refresh">
                            <label for="refresh">Allow</label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" value="1" name="setting[refresh]" id="refresh">
                            <label for="refresh">Not Allow</label>
                        </div>
                        <!-- refresh -->
                        <div class="col-md-4">
                            <label class="col-md-12 p-0"><?= translate('show_quiz_URL') ?> <span class="required">*</span></label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" value="0" name="setting[url]" checked id="url">
                            <label for="url">Allow</label>
                        </div>
                        <div class="col-md-4">
                            <input type="radio" value="1" name="setting[url]" id="url">
                            <label for="url">Not Allow</label>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label"><?= translate('total_marks') ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <input type="number" id="total_marks" name="total_marks" class="form-control" min="0" value="">
                        <span class="error"></span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label"><?= translate("Quiz's_time") ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <input type="number" id="quiz_time" name="quiz_time" class="form-control" min="0" value="">
                        <span class="error"></span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">Publish Date <span class="required">*</span></label>
                    <div class="col-md-6">
                        <div class="input-group">
                            <span class="input-group-addon"><i class="far fa-calendar-alt"></i></span>
                            <input type="text" class="form-control" name="publish_date" id="publish_date" autocomplete="off" data-plugin-datepicker data-plugin-options='{ "todayHighlight" : true }' />
                        </div>
                        <span class="error"></span>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">Expire Date <span class="required">*</span></label>
                    <div class="col-md-6">
                        <div class="input-group">
                            <span class="input-group-addon"><i class="far fa-calendar-alt"></i></span>
                            <input type="text" class="form-control" name="expire_date" id="expire_date" autocomplete="off" data-plugin-datepicker data-plugin-options='{ "todayHighlight" : true }' />
                        </div>
                        <span class="error"></span>
                    </div>
                </div>
                <!-- <div class="form-group">
                    <div class="col-md-offset-3 col-md-6">
                        <div class="checkbox-replace">
                            <label class="i-checks"><input type="checkbox" name="timerStatus" id="timerStatus"><i></i>Timer Per Question</label>
                        </div>
                    </div>
                    <div class="col-md-12 mt-sm"></div>
                    <label class="col-md-3 control-label">Minutes<span class="required">*</span></label>
                    <div class="col-md-6">
                        <div class="input-group">
                            <span class="input-group-addon"><i class="far fa-clock"></i></span>
                            <input type="number" class="form-control" name="timer" id="timer" min="0" disabled />
                        </div>
                        <span class="error"></span>
                    </div>
                </div> -->
                <div class="form-group">
                    <label class="col-md-3 control-label"><?php echo translate('time_slot'); ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <div class="row">
                            <div class="col-xs-6">
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="far fa-clock"></i></span>
                                    <input type="text" data-plugin-timepicker class="form-control" name="time_start" value="<?php echo set_value('time_start'); ?>" />
                                </div>
                                <span class="error"></span>
                            </div>
                            <div class="col-xs-6">
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="far fa-clock"></i></span>
                                    <input type="text" data-plugin-timepicker class="form-control" name="time_end" value="<?php echo set_value('time_end'); ?>" />
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <footer class="panel-footer">
                <div class="row">
                    <!-- onclick="getQuizModal()" -->
                    <div class="col-md-offset-3 col-md-2">
                        <button onclick="getQuizModal()" class="btn btn-default btn-block" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
                            <i class="fas fa-plus-circle"></i> <?= translate('Create Quiz') ?>
                        </button>
                    </div>
                </div>
            </footer>
            <?php echo form_close(); ?>
        </section>
    </div>
</div>

<!-- model question-->
<div class="zoom-anim-dialog modal-block modal-block-lg mfp-hide" id="modal">
    <section class="panel">
        <header class="panel-heading">
            <div>
                <h4 class="panel-title" style="display: inline-block;"><i class="fas fa-canel"></i> <?php echo translate('Create') . " " . translate('Quiz'); ?></h4>
                <span class="panel-title text-right modal-dismiss close" style="float: right;"><i class="fas fa-times"></i></span>
            </div>
        </header>
        <div class="panel-body">
            <div id='quick_view'>
                <?php echo form_open_multipart($this->uri->uri_string(), array('class' => 'form-bordered form-horizontal frm-submit-data form-question'));
                ?>
                <input name="step" type="hidden" class="form-control" value="step2">
            </div>
        </div>
        <footer class="panel-footer">
            <div class="row">
                <div class="col-md-6">
                    <button data-no="0" type="submit" class="btn btn-default" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
                        <i class="fas fa-plus-circle"></i> <?= translate('Save') ?>
                    </button>
                </div>
                <div class="col-md-6 text-right">
                    <a data-no="0" onclick="getQuizTypeModal()" class="btn btn-default" id="add-ques" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
                        <i class="fas fa-plus-circle"></i> <?= translate('Add Question') ?>
                    </a>
                </div>
            </div>
        </footer>
        <?php echo form_close();
        ?>
    </section>
</div>
<!-- model type -->
<div class="zoom-anim-dialog modal-block modal-block-lg mfp-hide" id="modalType">
    <section class="panel">
        <header class="panel-heading">
            <div>
                <h4 class="panel-title" style="display: inline-block;"><i class="fas fa-canel"></i> <?php echo translate('Question') . " " . translate('Type'); ?></h4>
                <span onclick="show()" class="panel-title text-right" style="float: right;"><i class="fas fa-times"></i></span>
            </div>
        </header>
        <div class="panel-body">
            <div id='quick_view_type'></div>
        </div>
        <footer class="panel-footer">
            <div class="row">
                <div class="col-md-12 text-right">
                    <button onclick="getQuizType()" class="btn btn-default" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
                        <i class="fas fa-plus-circle"></i> <?= translate('Add') ?>
                    </button>
                </div>
            </div>
        </footer>
    </section>
</div>

<script type="text/javascript">
    var quizType = '';
    $(document).ready(function() {
        $('#branch_id').on('change', function() {
            var branchID = $(this).val();
            getClassByBranch(branchID);
            $('#subject_id').html('').append('<option value=""><?= translate("select") ?></option>');
        });

        $('#section_id').on('change', function() {
            var classID = $('#class_id').val();
            var sectionID = $(this).val();
            $.ajax({
                url: base_url + 'subject/getByClassSection',
                type: 'POST',
                data: {
                    classID: classID,
                    sectionID: sectionID
                },
                success: function(data) {
                    $('#subject_id').html(data);
                }
            });
        });
        $('#timerStatus').on('change', function() {
            if ($(this).is(':checked')) {
                var date_of_homework = $('#date_of_homework').val()
                $('#timer').val(date_of_homework);
                $('#timer').prop("disabled", false);
            } else {
                $('#timer').val("");
                $('#timer').prop("disabled", true);
            }
        });
    });

    function show() {
        mfp_modal('#modal')
    }

    function getQuizModal() {
        var aForm = $('form').serializeArray();
        if (validation(aForm)) {
            // $('.error').empty()
            mfp_modal('#modal');
        }
    }

    function getQuizTypeModal() {
        $.ajax({
            url: base_url + 'quiz/quizTypeModel',
            type: 'POST',
            dataType: "html",
            success: function(data) {
                $('#quick_view_type').html(data);
                mfp_modal('#modalType');
            }
        });
    }

    function getQuizType() {
        var quesNo = $('#add-ques').attr('data-no');
        var type = $('input[name="question_type"]:checked').val();
        quesNo++;
        $('#add-ques').attr('data-no', quesNo);
        $.ajax({
            url: base_url + 'quiz/quizModal',
            type: 'POST',
            data: {
                'type': type,
                'quesNo': $('#add-ques').attr('data-no')
            },
            dataType: "html",
            success: function(data) {
                $('.form-question').append(data);
                mfp_modal('#modal');
            }
        });
    }

    // function deleteQuestion(target) {
    //     $(target).parent().parent().parent().parent().parent().remove();
    //     var quesNo = $('#add-ques').attr('data-no');
    //     quesNo--;
    //     $('#add-ques').attr('data-no', quesNo);
    // }

    function deleteQuestion(target) {
        $(target).parent().parent().remove();
        var quesNo = $('#add-ques').attr('data-no');
        quesNo--;
        $('#add-ques').attr('data-no', quesNo);
    }


    function validation(aForm) {
        var status = true;
        $.each(aForm, function(k, v) {
            if (v['value'] == '' && k > 2) {
                status = false;
            }
        })
        return status;
    }

    function timerStatus(self) {
        var value = $(self).val()
        if (value == 1) {
            $('#quiz_time').prop("disabled", false);
        }
        if (value == 0) {
            $('#quiz_time').val("");
            $('#quiz_time').prop("disabled", true);
        }
    }


    


    
</script>