<?php
$div = 0;
if (get_permission('employee_count_widget', 'is_view')) {
	$div++;
}
if (get_permission('student_count_widget', 'is_view')) {
	$div++;
}
if (get_permission('parent_count_widget', 'is_view')) {
	$div++;
}
if (get_permission('teacher_count_widget', 'is_view')) {
	$div++;
}
if ($div == 0) {
	$widget1 = 0;
} else {
	$widget1 = 12 / $div;
}

$div2 = 0;
if (get_permission('admission_count_widget', 'is_view')) {
	$div2++;
}
if (get_permission('voucher_count_widget', 'is_view')) {
	$div2++;
}
if (get_permission('transport_count_widget', 'is_view')) {
	$div2++;
}
if (get_permission('hostel_count_widget', 'is_view')) {
	$div2++;
}
if ($div2 == 0) {
	$widget2 = 0;
} else {
	$widget2 = 12 / $div2;
}
?>
<?php if (is_teacher_loggedin()) : $widget = (is_superadmin_loggedin() ? 4 : 6); ?>
	<section class="panel">
		<header class="panel-heading">
			<h4 class="panel-title"><?= translate('select_ground') ?></h4>
			<?php if (get_permission('class_timetable', 'is_add')) { ?>
				<div class="panel-btn">
					<a href="<?= base_url('timetable/set_classwise') ?>" class="btn btn-default btn-circle">
						<i class="fas fa-plus-circle"></i> <?= translate('add') . " " . translate('schedule') ?>
					</a>
				</div>
			<?php } ?>
		</header>
		<?php echo form_open($this->uri->uri_string(), array('class' => 'validate')); ?>
		<div class="panel-body">
			<div class="row mb-sm">
				<?php if (is_superadmin_loggedin()) : ?>
					<div class="col-md-4 mb-sm">
						<div class="form-group">
							<label class="control-label"><?= translate('branch') ?> <span class="required">*</span></label>
							<?php
							$arrayBranch = $this->app_lib->getSelectList('branch');
							echo form_dropdown("branch_id", $arrayBranch, set_value('branch_id'), "class='form-control' required onchange='getClassByBranch(this.value)'
						data-width='100%' data-plugin-selectTwo data-minimum-results-for-search='Infinity'");
							?>
						</div>
					</div>
				<?php endif; ?>
				<div class="col-md-<?php echo $widget; ?> mb-sm">
					<div class="form-group">
						<label class="control-label"><?= translate('class') ?> <span class="required">*</span></label>
						<?php
						$arrayClass = $this->app_lib->getClass($branch_id);
						echo form_dropdown("class_id", $arrayClass, set_value('class_id'), "class='form-control' id='class_id' onchange='getSectionByClass(this.value,0)'
						required data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
						?>
					</div>
				</div>
				<div class="col-md-<?php echo $widget; ?> mb-sm">
					<div class="form-group">
						<label class="control-label"><?= translate('section') ?> <span class="required">*</span></label>
						<?php
						$arraySection = $this->app_lib->getSections(set_value('class_id'));
						echo form_dropdown("section_id", $arraySection, set_value('section_id'), "class='form-control' id='section_id' required 
						data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
						?>
					</div>
				</div>
			</div>
		</div>
		<footer class="panel-footer">
			<div class="row">
				<div class="col-md-offset-10 col-md-2">
					<button type="submit" class="btn btn btn-default btn-block"> <i class="fas fa-filter"></i> <?= translate('filter') ?></button>
				</div>
			</div>
		</footer>
		<?php echo form_close(); ?>
	</section>
	<?php if(isset($timetables)): ?>
	<section class="panel appear-animation mt-sm" data-appear-animation="<?php echo $global_config['animations'];?>" data-appear-animation-delay="100">
		<header class="panel-heading">
			<div class="panel-btn">
			<?php if (get_permission('class_timetable', 'is_edit')): ?>
				<a class="edit_modal btn btn-default btn-circle icon" href="javascript:void(0);">
					<i class="fas fa-pen-nib"></i>
				</a>
			<?php endif; ?>
				<button onclick="fn_printElem('printResult')" class="btn btn-default btn-circle icon"><i class="fas fa-print"></i></button>
			</div>
			<h4 class="panel-title"><i class="fas fa-user-clock"></i> <?=translate('schedule') . " " . translate('list')?></h4>
		</header>
		<div class="panel-body">
			<?php if(count($timetables) > 0){ ?>
			<div class="table-responsive">
				<div id="printResult">
					<!-- hidden school information prints -->
					<div class="visible-print">
						<center>
							<h4 class="text-dark text-weight-bold"><?=$global_config['institute_name']?></h4>
							<h5 class="text-dark"><?=$global_config['address']?></h5>
							<h5 class="text-dark text-weight-bold">Class Timetable</h5>
							<h5 class="text-dark">
								<?php 
								echo translate('class') . ' : ' . get_type_name_by_id('class', $class_id);
								echo ' ( ' . translate('section') . ' : ' .  get_type_name_by_id('section', $section_id) .  ' )';
								?>
							</h5>
							<hr>
						</center>
					</div>
					<table class="table table-bordered table-hover table-condensed text-dark">
						<tbody>
						<?php
						$days = array(
							'sunday',
							'monday',
							'tuesday',
							'wednesday',
							'thursday',
							'friday',
							'saturday'
						);
						$mapfunction = function($s) {return $s->day;};
						$count = array_count_values(array_map($mapfunction, $timetables));
						$max = max($count);
						foreach ($days as $key => $day):
							echo '<tr>';
								echo '<td class="timetable">' . strtoupper($day) . '</td>';
								$row_count = 0;
								foreach ($timetables as $timetable){
									if($timetable->day == $day) {
										$row_count ++;
										echo '<td class="center">';
										if($timetable->break == 0){
											echo '<strong>' . get_type_name_by_id('subject', $timetable->subject_id) . '</strong><br>';
										} else{
											echo '<strong>BREAK</strong><br>';
										}
										echo '<small> (' . date("g:i A", strtotime($timetable->time_start)) . ' - ' . date("g:i A", strtotime($timetable->time_end)) . ')</small><br>';
										if($timetable->break == 0)
											echo '<small>' . translate('teacher') . ' : ' . get_type_name_by_id('staff', $timetable->teacher_id) . '</small>';
										echo ($timetable->class_room != '' ? '<br>' . translate('class_room') . ' : ' . $timetable->class_room : '');
										
										echo '</td>';
									}
								}
								while($row_count<$max) {
									echo '<td class="center">N/A</td>';
									$row_count++;
								}
							echo '</tr>';
						endforeach;
						?>
						</tbody>
					</table>
				</div>
			</div>
			<?php
				}else{
					echo '<div class="alert alert-subl mt-md text-center"><strong>Oops!</strong> No Schedule Was Made !</div>';
				}
			?>
		</div>
	</section>
	<div class="zoom-anim-dialog modal-block modal-block-primary mfp-hide" id="modal">
		<section class="panel">
			<div class="panel-heading">
				<h4 class="panel-title">
					<i class="fas fa-pen-nib"></i> <?=translate('schedule') . ' ' . translate('edit')?>
				</h4>
			</div>
			<?php echo form_open('timetable/update_classwise', array('target' => '_blank', 'class' => ' validate')); ?>
			<div class="panel-body">
				<div class="form-group mt-sm mb-lg">
					<label class="control-label"><?=translate('day')?> <span class="required">*</span></label>
					<?php
						$arrayDay = array(
							"sunday" => "Sunday",
							"monday" => "Monday",
							"tuesday" => "Tuesday",
							"wednesday" => "Wednesday",
							"thursday" => "Thursday",
							"friday" => "Friday",
							"saturday" => "Saturday"
						);
						echo form_dropdown("day", $arrayDay, set_value('day'), "class='form-control' required
						data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' ");
					?>
				</div>
				<?php 
					$data = array(
						'branch_id' => $branch_id,
						'class_id' => $class_id,
						'section_id' => $section_id
					);
					echo form_hidden($data);
				?>
			</div>
			<footer class="panel-footer">
				<div class="text-right">
					<button type="submit" id="submit" class="btn btn-default"><?=translate('done')?></button>
					<button class="btn btn-default modal-dismiss"><?=translate('cancel')?></button>
				</div>
			</footer>
			<?php echo form_close();?>
		</section>
	</div>
<?php endif;?>
<?php endif; ?>
<div class="dashboard-page">
	<div class="row">
		<?php if (get_permission('monthly_income_vs_expense_chart', 'is_view')) { ?>
			<!-- monthly cash book transaction -->
			<div class="<?php echo get_permission('annual_student_fees_summary_chart', 'is_view') ? 'col-md-12 col-lg-4 col-xl-3' : 'col-md-12'; ?>">
				<section class="panel pg-fw">
					<div class="panel-body">
						<h4 class="chart-title mb-xs"><?= translate('income_vs_expense_of') . " " . date('F') ?></h4>
						<div id="cash_book_transaction"></div>
						<div class="round-overlap"><i class="fab fa-sellcast"></i></div>
						<div class="text-center">
							<ul class="list-inline">
								<li>
									<h6 class="text-muted"><i class="fa fa-circle text-blue"></i> <?= translate('income') ?></h6>
								</li>
								<li>
									<h6 class="text-muted"><i class="fa fa-circle text-danger"></i> <?= translate('expense') ?></h6>
								</li>
							</ul>
						</div>
					</div>
				</section>
			</div>
		<?php } ?>
		<?php if (get_permission('annual_student_fees_summary_chart', 'is_view')) { ?>
			<!-- student fees summary graph -->
			<div class="<?php echo get_permission('monthly_income_vs_expense_chart', 'is_view') ? 'col-md-12 col-lg-8 col-xl-9' : 'col-md-12'; ?>">
				<section class="panel">
					<div class="panel-body">
						<h4 class="chart-title mb-md"><?= translate('annual_fee_summary') ?></h4>
						<div class="pe-chart">
							<canvas id="fees_graph" style="height: 322px;"></canvas>
						</div>
					</div>
				</section>
			</div>
		<?php } ?>
	</div>
	<?php if ($widget1 > 0) { ?>
		<div class="row">
			<div class="col-md-12 col-lg-12 col-sm-12">
				<div class="panel">
					<div class="row widget-row-in">
						<?php if (get_permission('employee_count_widget', 'is_view')) { ?>
							<div class="col-lg-<?php echo $widget1; ?> col-sm-6 ">
								<div class="panel-body">
									<div class="widget-col-in row">
										<div class="col-md-6 col-sm-6 col-xs-6"> <i class="fas fa-users"></i>
											<h5 class="text-muted"><?php echo translate('employee'); ?></h5>
										</div>
										<div class="col-md-6 col-sm-6 col-xs-6">
											<h3 class="counter text-right mt-md text-primary"><?php
																								$staff = $this->dashboard_model->getstaffcounter('', $school_id);
																								echo $staff['snumber'];
																								?></h3>
										</div>
										<div class="col-md-12 col-sm-12 col-xs-12">
											<div class="box-top-line line-color-primary">
												<span class="text-muted text-uppercase"><?php echo translate('total_strength'); ?></span>
											</div>
										</div>
									</div>
								</div>
							</div>
						<?php } ?>
						<?php if (get_permission('student_count_widget', 'is_view')) { ?>
							<div class="col-lg-<?php echo $widget1; ?> col-sm-6">
								<div class="panel-body">
									<div class="widget-col-in row">
										<div class="col-md-6 col-sm-6 col-xs-6"> <i class="fas fa-user-graduate"></i>
											<h5 class="text-muted"><?php echo translate('students'); ?></h5>
										</div>
										<div class="col-md-6 col-sm-6 col-xs-6">
											<h3 class="counter text-right mt-md text-primary"><?= $get_total_student ?></h3>
										</div>
										<div class="col-md-12 col-sm-12 col-xs-12">
											<div class="box-top-line line-color-primary">
												<span class="text-muted text-uppercase"><?php echo translate('total_strength'); ?></span>
											</div>
										</div>
									</div>
								</div>
							</div>
						<?php } ?>
						<?php if (get_permission('parent_count_widget', 'is_view')) { ?>
							<div class="col-lg-<?php echo $widget1; ?> col-sm-6 ">
								<div class="panel-body">
									<div class="widget-col-in row">
										<div class="col-md-6 col-sm-6 col-xs-6"> <i class="fas fa-user-tie"></i>
											<h5 class="text-muted"><?php echo translate('parents'); ?></h5>
										</div>
										<div class="col-md-6 col-sm-6 col-xs-6">
											<h3 class="counter text-right mt-md text-primary"><?php
																								if (!empty($school_id))
																									$this->db->where('branch_id', $school_id);
																								echo $this->db->select('id')->get('parent')->num_rows();
																								?></h3>
										</div>
										<div class="col-md-12 col-sm-12 col-xs-12">
											<div class="box-top-line line-color-primary">
												<span class="text-muted text-uppercase"><?php echo translate('total_strength'); ?></span>
											</div>
										</div>
									</div>
								</div>
							</div>
						<?php } ?>
						<?php if (get_permission('teacher_count_widget', 'is_view')) { ?>
							<div class="col-lg-<?php echo $widget1; ?> col-sm-6 ">
								<div class="panel-body">
									<div class="widget-col-in row">
										<div class="col-md-6 col-sm-6 col-xs-6"> <i class="fas fa-chalkboard-teacher"></i>
											<h5 class="text-muted"><?php echo translate('teachers'); ?></h5>
										</div>
										<div class="col-md-6 col-sm-6 col-xs-6">
											<h3 class="counter text-right mt-md text-primary"><?php
																								$staff = $this->dashboard_model->getstaffcounter(3, $school_id);
																								echo $staff['snumber'];
																								?></h3>
										</div>
										<div class="col-md-12 col-sm-12 col-xs-12">
											<div class="box-top-line line-color-primary">
												<span class="text-muted text-uppercase"><?= translate('total_strength') ?></span>
											</div>
										</div>
									</div>
								</div>
							</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>
	<!-- student quantity chart -->
	<div class="row">
		<?php if (get_permission('student_quantity_pie_chart', 'is_view')) { ?>
			<div class="<?php echo get_permission('weekend_attendance_inspection_chart', 'is_view') ? 'col-md-12 col-lg-4 col-xl-3' : 'col-md-12'; ?>">
				<section class="panel pg-fw">
					<div class="panel-body">
						<h4 class="chart-title mb-xs"><?= translate('student_quantity') ?></h4>
						<div id="student_strength"></div>
						<div class="round-overlap"><i class="fas fa-school"></i></div>
					</div>
				</section>
			</div>
		<?php } ?>
		<?php if (get_permission('weekend_attendance_inspection_chart', 'is_view')) { ?>
			<div class="<?php echo get_permission('student_quantity_pie_chart', 'is_view') ? 'col-md-12 col-lg-8 col-xl-9' : 'col-md-12'; ?>">
				<section class="panel">
					<div class="panel-body">
						<h4 class="chart-title mb-md"><?= translate('weekend_attendance_inspection') ?></h4>
						<div class="pg-fw">
							<canvas id="weekend_attendance" style="height: 340px;"></canvas>
						</div>
					</div>
				</section>
			</div>
		<?php } ?>
	</div>
	<?php if ($widget2 > 0) { ?>
		<div class="row">
			<div class="col-md-12 col-lg-12 col-sm-12">
				<div class="panel">
					<div class="row widget-row-in">
						<?php if (get_permission('admission_count_widget', 'is_view')) { ?>
							<div class="col-lg-<?php echo $widget2; ?> col-sm-6 ">
								<div class="panel-body">
									<div class="widget-col-in row">
										<div class="col-md-6 col-sm-6 col-xs-6"> <i class="far fa-address-card"></i>
											<h5 class="text-muted"><?php echo translate('admission'); ?></h5>
										</div>
										<div class="col-md-6 col-sm-6 col-xs-6">
											<h3 class="counter text-right mt-md text-primary"><?= $get_monthly_admission; ?></h3>
										</div>
										<div class="col-md-12 col-sm-12 col-xs-12">
											<div class="box-top-line line-color-primary">
												<span class="text-muted text-uppercase"><?php echo translate('interval_month'); ?></span>
											</div>
										</div>
									</div>
								</div>
							</div>
						<?php } ?>
						<?php if (get_permission('voucher_count_widget', 'is_view')) { ?>
							<div class="col-lg-<?php echo $widget2; ?> col-sm-6">
								<div class="panel-body">
									<div class="widget-col-in row">
										<div class="col-md-6 col-sm-6 col-xs-6"> <i class="fas fa-money-check-alt"></i>
											<h5 class="text-muted"><?php echo translate('voucher'); ?></h5>
										</div>
										<div class="col-md-6 col-sm-6 col-xs-6">
											<h3 class="counter text-right mt-md text-primary"><?= $get_voucher ?></h3>
										</div>
										<div class="col-md-12 col-sm-12 col-xs-12">
											<div class="box-top-line line-color-primary">
												<span class="text-muted text-uppercase"><?php echo translate('total_number'); ?></span>
											</div>
										</div>
									</div>
								</div>
							</div>
						<?php } ?>
						<?php if (get_permission('transport_count_widget', 'is_view')) { ?>
							<div class="col-lg-<?php echo $widget2; ?> col-sm-6 ">
								<div class="panel-body">
									<div class="widget-col-in row">
										<div class="col-md-6 col-sm-6 col-xs-6"> <i class="fas fa-road"></i>
											<h5 class="text-muted"><?php echo translate('transport'); ?></h5>
										</div>
										<div class="col-md-6 col-sm-6 col-xs-6">
											<h3 class="counter text-right mt-md text-primary"><?= $get_transport_route ?></h3>
										</div>
										<div class="col-md-12 col-sm-12 col-xs-12">
											<div class="box-top-line line-color-primary">
												<span class="text-muted text-uppercase"><?php echo translate('total_route'); ?></span>
											</div>
										</div>
									</div>
								</div>
							</div>
						<?php } ?>
						<?php if (get_permission('hostel_count_widget', 'is_view')) { ?>
							<div class="col-lg-<?php echo $widget2; ?> col-sm-6 ">
								<div class="panel-body">
									<div class="widget-col-in row">
										<div class="col-md-6 col-sm-6 col-xs-6"> <i class="fas fa-warehouse"></i>
											<h5 class="text-muted"><?php echo translate('hostel'); ?></h5>
										</div>
										<div class="col-md-6 col-sm-6 col-xs-6">
											<h3 class="counter text-right mt-md text-primary"><?php
																								if (!empty($school_id))
																									$this->db->where('branch_id', $school_id);
																								$hostel_room = $this->db->select('id')->get('hostel_room')->num_rows();
																								echo $hostel_room;
																								?></h3>
										</div>
										<div class="col-md-12 col-sm-12 col-xs-12">
											<div class="box-top-line line-color-primary">
												<span class="text-muted text-uppercase"><?= translate('total_room') ?></span>
											</div>
										</div>
									</div>
								</div>
							</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>
	<div class="row">
		<!-- event calendar -->
		<div class="col-md-12">
			<section class="panel">
				<div class="panel-body">
					<div id="event_calendar"></div>
				</div>
			</section>
		</div>
	</div>
</div>

<div class="zoom-anim-dialog modal-block modal-block-primary mfp-hide" id="modal">
	<section class="panel">
		<header class="panel-heading">
			<div class="panel-btn">
				<button onclick="fn_printElem('printResult')" class="btn btn-default btn-circle icon"><i class="fas fa-print"></i></button>
			</div>
			<h4 class="panel-title"><i class="fas fa-info-circle"></i> <?= translate('event_details') ?></h4>
		</header>
		<div class="panel-body">
			<div id="printResult" class=" pt-sm pb-sm">
				<div class="table-responsive">
					<table class="table table-bordered table-condensed text-dark tbr-top" id="ev_table">

					</table>
				</div>
			</div>
		</div>
		<footer class="panel-footer">
			<div class="row">
				<div class="col-md-12 text-right">
					<button class="btn btn-default modal-dismiss">
						<?= translate('close') ?>
					</button>
				</div>
			</div>
		</footer>
	</section>
</div>

<script type="application/javascript">

	(function($) {
		$('#event_calendar').fullCalendar({
			header: {
				left: 'prev,next,today',
				center: 'title',
				right: 'month,agendaWeek,agendaDay,listWeek'
			},
			firstDay: 1,
			height: 720,
			droppable: false,
			editable: true,
			events: {
				url: "<?= base_url('event/get_events_list/' . $school_id) ?>"
			},
			buttonText: {
				today: 'Today',
				month: 'Month',
				week: 'Week',
				day: 'Day',
				list: 'List'
			},
			eventRender: function(event, element) {
				$(element).on("click", function() {
					viewEvent(event.id);
				});
				if (event.icon) {
					element.find(".fc-title").prepend("<i class='fas fa-" + event.icon + "'></i> ");
				}
			}
		});

		// Annual Fee Summary JS
		var total_fees = <?php echo json_encode($fees_summary["total_fee"]); ?>;
		var total_paid = <?php echo json_encode($fees_summary["total_paid"]); ?>;
		var total_due = <?php echo json_encode($fees_summary["total_due"]); ?>;
		var feesGraph = {
			type: 'line',
			data: {
				labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
				datasets: [{
					label: '<?php echo translate("total"); ?>',
					data: total_fees,
					backgroundColor: 'rgba(216, 27, 96, .6)',
					borderColor: '#F5F5F5',
					borderWidth: 1
				}, {
					label: '<?php echo translate("collected"); ?>',
					data: total_paid,
					backgroundColor: 'rgba(0, 136, 204, .6)',
					borderColor: '#F5F5F5',
					borderWidth: 1
				}, {
					label: '<?php echo translate("remaining"); ?>',
					data: total_due,
					backgroundColor: 'rgba(204, 102, 102, .6)',
					borderColor: '#F5F5F5',
					borderWidth: 1
				}]
			},
			options: {
				responsive: true,
				maintainAspectRatio: false,
				circumference: Math.PI,
				tooltips: {
					mode: 'index',
					bodySpacing: 4
				},
				legend: {
					position: 'bottom',
					labels: {
						boxWidth: 12
					}
				},
				scales: {
					xAxes: [{
						scaleLabel: {
							display: false
						}
					}],
					yAxes: [{
						stacked: true,
						scaleLabel: {
							display: false,
						}
					}]
				}
			}
		}

		var days = <?php echo json_encode($weekend_attendance["days"]); ?>;
		var employees_att = <?php echo json_encode($weekend_attendance["employee_att"]); ?>;
		var student_att = <?php echo json_encode($weekend_attendance["student_att"]); ?>;
		var weekendAttendanceChart = {
			type: 'bar',
			data: {
				labels: days,
				datasets: [{
					label: '<?php echo translate("employee"); ?>',
					data: employees_att,
					backgroundColor: 'rgba(0, 136, 204, .6)',
					borderColor: '#F5F5F5',
					borderWidth: 1,
					fill: false,
				}, {
					label: '<?php echo translate("student"); ?>',
					data: student_att,
					backgroundColor: 'rgba(204, 102, 102, .6)',
					borderColor: '#F5F5F5',
					borderWidth: 1,
					fill: false,
				}]
			},
			options: {
				responsive: true,
				maintainAspectRatio: false,
				circumference: Math.PI,
				tooltips: {
					mode: 'index',
					bodySpacing: 4
				},
				legend: {
					position: 'bottom',
					labels: {
						boxWidth: 12
					}
				},
				scales: {
					xAxes: [{
						scaleLabel: {
							display: false
						}
					}],
					yAxes: [{
						scaleLabel: {
							display: false,
						}
					}]
				}
			}
		};

		<?php if (get_permission('annual_student_fees_summary_chart', 'is_view')) { ?>
			var ctx = document.getElementById('fees_graph').getContext('2d');
			window.myLine = new Chart(ctx, feesGraph);
		<?php } ?>
		<?php if (get_permission('weekend_attendance_inspection_chart', 'is_view')) { ?>
			var ctx2 = document.getElementById('weekend_attendance').getContext('2d');
			window.myLine = new Chart(ctx2, weekendAttendanceChart);
		<?php } ?>
		<?php if (get_permission('monthly_income_vs_expense_chart', 'is_view')) { ?>
			// monthly income vs expense chart
			var cash_book_transaction = document.getElementById("cash_book_transaction");
			var cashbookchart = echarts.init(cash_book_transaction);
			cashbookchart.setOption({
				tooltip: {
					trigger: 'item',
					formatter: "{a} <br/>{b} : <?php echo $global_config["currency_symbol"]; ?> {c} ({d}%)"
				},
				legend: {
					show: false
				},
				color: ["#d81b60", "#009efb"],
				series: [{
					name: 'Transaction',
					type: 'pie',
					radius: ['75%', '90%'],
					itemStyle: {
						normal: {
							label: {
								show: false
							},
							labelLine: {
								show: false
							}
						},
						emphasis: {
							label: {
								show: false
							}
						}
					},
					data: <?= json_encode($income_vs_expense) ?>
				}]
			});
		<?php } ?>
		<?php if (get_permission('student_quantity_pie_chart', 'is_view')) { ?>
			// Student Strength Doughnut Chart
			var color = ['#546570', '#c4ccd3', '#c23531', '#2f4554', '#61a0a8', '#d48265', '#91c7ae', '#749f83', '#ca8622', '#bda29a', '#6e7074'];
			var strength_data = <?php echo json_encode($student_by_class); ?>;
			var student_strength = document.getElementById("student_strength");
			var studentchart = echarts.init(student_strength);
			studentchart.setOption({
				tooltip: {
					trigger: 'item',
					formatter: "{a} <br/>{b} : {c} ({d}%)"
				},
				legend: {
					type: 'scroll',
					x: 'center',
					y: 'bottom',
					itemWidth: 14,
					<?php if ($theme_config["dark_skin"] == "true") : ?>
						inactiveColor: '#4b4b4b',
						textStyle: {
							color: '#6b6b6c'
						}
					<?php endif; ?>
				},
				series: [{
					name: 'Strength',
					type: 'pie',
					color: color,
					radius: ['70%', '85%'],
					center: ['50%', '46%'],
					itemStyle: {
						normal: {
							label: {
								show: false
							},
							labelLine: {
								show: false
							}
						},
						emphasis: {
							label: {
								show: false
							}
						}
					},
					data: strength_data
				}]
			});
		<?php } ?>
		// charts resize
		$(".sidebar-toggle").on("click", function(event) {
			echartsresize();
		});

		$(window).on("resize", echartsresize);

		function echartsresize() {
			setTimeout(function() {
				if ($("#student_strength").length) {
					studentchart.resize();
				}
				if ($("#cash_book_transaction").length) {
					cashbookchart.resize();
				}
			}, 350);
		}
	})(jQuery);
</script>