<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Userrole_model extends MY_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function getTeachersList($branchID = '')
    {
        $this->db->select('staff.*,staff_designation.name as designation_name,staff_department.name as department_name,login_credential.role as role_id, roles.name as role');
        $this->db->from('staff');
        $this->db->join('login_credential', 'login_credential.user_id = staff.id and login_credential.role != "6" and login_credential.role != "7"', 'inner');
        $this->db->join('roles', 'roles.id = login_credential.role', 'left');
        $this->db->join('staff_designation', 'staff_designation.id = staff.designation', 'left');
        $this->db->join('staff_department', 'staff_department.id = staff.department', 'left');
        if ($branchID != "") {
            $this->db->where('staff.branch_id', $branchID);
        }
        $this->db->where('login_credential.role', 3);
        $this->db->where('login_credential.active', 1);
        $this->db->order_by('staff.id', 'ASC');
        return $this->db->get()->result();
    }

    // get route information by route id and vehicle id
    public function getRouteDetails($routeID, $vehicleID)
    {
        $this->db->select('ta.route_id,ta.stoppage_id,ta.vehicle_id,r.name as route_name,r.start_place,r.stop_place,sp.stop_position,sp.stop_time,sp.route_fare,v.vehicle_no,v.driver_name,v.driver_phone');
        $this->db->from('transport_assign as ta');
        $this->db->join('transport_route as r', 'r.id = ta.route_id', 'left');
        $this->db->join('transport_vehicle as v', 'v.id = ta.vehicle_id', 'left');
        $this->db->join('transport_stoppage as sp', 'sp.id = ta.stoppage_id', 'left');
        $this->db->where('ta.route_id', $routeID);
        $this->db->where('ta.vehicle_id', $vehicleID);
        return $this->db->get()->row_array();
    }

    public function getAssignList($branch_id = '')
    {
        $this->db->select('ta.route_id,ta.stoppage_id,ta.branch_id,r.name,r.start_place,r.stop_place,sp.stop_position,sp.stop_time,sp.route_fare');
        $this->db->from('transport_assign as ta');
        $this->db->join('transport_route as r', 'r.id = ta.route_id', 'left');
        $this->db->join('transport_stoppage as sp', 'sp.id = ta.stoppage_id', 'left');
        $this->db->group_by(array('ta.route_id', 'ta.stoppage_id', 'ta.branch_id'));
        if (!empty($branch_id)) {
            $this->db->where('ta.branch_id', $branch_id);
        }
        return $this->db->get()->result_array();
    }

    // get vehicle list by route_id
    public function getVehicleList($route_id)
    {
        $this->db->select('ta.vehicle_id,v.vehicle_no');
        $this->db->from('transport_assign as ta');
        $this->db->join('transport_vehicle as v', 'v.id = ta.vehicle_id', 'left');
        $this->db->where('ta.route_id', $route_id);
        $vehicles = $this->db->get()->result();
        $name_list = '';
        foreach ($vehicles as $row) {
            $name_list .= '- ' . $row->vehicle_no . '<br>';
        }
        return $name_list;
    }

    // get hostel information by hostel id and room id
    public function getHostelDetails($hostelID, $roomID)
    {
        $this->db->select('h.name as hostel_name,h.watchman,h.category_id,h.address,hc.name as hcategory_name,rc.name as rcategory_name,hr.name as room_name,hr.no_beds,hr.bed_fee');
        $this->db->from('hostel as h');
        $this->db->join('hostel_category as hc', 'hc.id = h.category_id', 'left');
        $this->db->join('hostel_room as hr', 'hr.hostel_id = h.id', 'left');
        $this->db->join('hostel_category as rc', 'rc.id = hr.category_id', 'left');
        $this->db->where('hr.id', $roomID);
        $this->db->where('h.id', $hostelID);
        return $this->db->get()->row();
    }

    // check attendance by staff id and date
    public function get_attendance_by_date($studentID, $date)
    {
        $sql = "SELECT student_attendance.* FROM student_attendance WHERE student_id = " . $this->db->escape($studentID) . " AND date = " . $this->db->escape($date);
        return $this->db->query($sql)->row_array();
    }


    public function getStudentDetails()
    {
        if (is_student_loggedin()) {
            $studentID = get_loggedin_user_id();
        } elseif (is_parent_loggedin()) {
            $studentID = get_activeChildren_id();
        }
        $this->db->select('CONCAT(s.first_name, " ", s.last_name) as fullname,s.email as student_email,e.branch_id,e.student_id,s.hostel_id,s.room_id,s.route_id,s.vehicle_id,s.register_no, e.class_id,e.section_id,c.name as class_name,se.name as section_name,b.school_name,b.email as school_email,b.mobileno as school_mobileno,b.address as school_address');
        $this->db->from('enroll as e');
        $this->db->join('student as s', 's.id = e.student_id', 'inner');
        $this->db->join('branch as b', 'b.id = e.branch_id', 'left');
        $this->db->join('class as c', 'c.id = e.class_id', 'left');
        $this->db->join('section as se', 'se.id = e.section_id', 'left');
        $this->db->where('s.id', $studentID);
        return $this->db->get()->row_array();
    }
    // $this->CI->db->join('subject_assign as sa', 'LIKE CONCAT(\'%\', Table2.col, \'%\')', 'left');




    // UNCOMMEMT THIS FUNCTION AFTER HOMEWORK UNLOCK


    public function getHomeworkList($studentID, $studentSectionID)
    {
        $this->db->select('homework.*,CONCAT(s.first_name, " ",s.last_name) as fullname,s.register_no,e.student_id, e.roll,subject.name as subject_name,class.name as class_name,he.id as ev_id,he.status as ev_status,he.remark as ev_remarks,he.rank');
        $this->db->from('homework');
        $this->db->join('enroll as e', 'e.class_id=homework.class_id and e.session_id = homework.session_id', 'inner');
        $this->db->join('student as s', 'e.student_id = s.id', 'inner');
        $this->db->join('homework_evaluation as he', 'he.homework_id = homework.id and he.student_id = e.student_id', 'left');
        $this->db->join('subject', 'subject.id = homework.subject_id', 'left');
        $this->db->join('class', 'class.id = homework.class_id', 'left');
        $this->db->join('section as sec', 'homework.section_id LIKE CONCAT(\'%"\', sec.id, \'"%\')', 'left');
        $this->db->where('sec.id', $studentSectionID);
        $this->db->where('e.student_id', $studentID);
        if (!is_superadmin_loggedin()) {
            $this->db->where('homework.branch_id', get_loggedin_branch_id());
        }
        $this->db->where('homework.status', 0);
        $this->db->where('homework.session_id', get_session_id());
        $this->db->order_by('homework.id', 'desc');
        $result = $this->db->get()->result_array();
    

        $currentDateTime = new DateTime(date('Y-m-d') . date("H:i"));
        // print_r($startDateTime->format('Y-m-d H:i'));
        // var_dump($currentDateTime->format('Y-m-d H:i') >= $startDateTime->format('Y-m-d H:i'));
        // die();
        if ($result) {
            foreach ($result as $k => $v) {
                $startDateTime = new DateTime($result[$k]['date_of_homework'] . $result[$k]['start_time']);
                $endDateTime = new DateTime($result[$k]['date_of_submission'] . $result[$k]['end_time']);
                $date_of_submission  = $result[$k]['date_of_submission'];
                $date = Date('Y-m-d');
                $count = $this->db->where(array('homework_id' => $result[$k]['id'], 'student_id' => $result[$k]['student_id']))
                    ->get('homework_student')
                    ->num_rows();
                if ($count == 1) {
                    $result[$k]['exisit'] = true;
                }
                if ($count == 0) {
                    $result[$k]['exisit'] = false;
                    if ($endDateTime <=  $currentDateTime) {
                        $result[$k]['late'] = true;
                    } else {
                        $result[$k]['late'] = false;
                    }
                }
                $result[$k]['currentTime'] = $currentDateTime->format('Y-m-d H:i');
                $result[$k]['startDateTime'] = $startDateTime->format('Y-m-d H:i');
                $result[$k]['endDateTime'] = $endDateTime->format('Y-m-d H:i');
            }
        }
        return $result;
    }

    //--------------------------------//




    // public function getHomeworkList($studentID, $studentSectionID)
    // {
    
    //     $this->db->select('homework.*,CONCAT(s.first_name, " ",s.last_name) as fullname,s.register_no,e.student_id, e.roll,subject.name as subject_name,class.name as class_name,he.id as ev_id,he.status as ev_status,he.remark as ev_remarks,he.rank');
    //     $this->db->from('homework');
    //     $this->db->join('enroll as e', 'e.class_id=homework.class_id and e.session_id = homework.session_id', 'inner');
    //     $this->db->join('student as s', 'e.student_id = s.id', 'inner');
    //     $this->db->join('homework_evaluation as he', 'he.homework_id = homework.id and he.student_id = e.student_id', 'left');
    //     $this->db->join('subject', 'subject.id = homework.subject_id', 'left');
    //     $this->db->join('class', 'class.id = homework.class_id', 'left');
    //     $this->db->join('section as sec', 'homework.section_id LIKE CONCAT(\'%"\', sec.id, \'"%\')', 'left');
    //     $this->db->where('sec.id', $studentSectionID);
    //     $this->db->where('e.student_id', $studentID);
    //     if (!is_superadmin_loggedin()) {
    //         $this->db->where('homework.branch_id', get_loggedin_branch_id());
    //     }
    //     $this->db->where('homework.status', 0);
    //     $this->db->where('homework.session_id', get_session_id());
    //             // $this->db->where("CURRENT_DATE() >= ",date_of_homework);
    //             // $this->db->where("CURRENT_DATE()<= ",date_of_submission );
    //     $this->db->where("date_of_homework <=",date("Y-m-d"));
    //     $this->db->where("date_of_submission>= ",date("Y-m-d") );


    //     $this->db->order_by('homework.id', 'desc');
    //     $result = $this->db->get()->result_array();
    
    
    //     $currentDateTime = new DateTime(date('Y-m-d') . date("H:i"));
    //     // print_r($startDateTime->format('Y-m-d H:i'));
    //     // var_dump($currentDateTime->format('Y-m-d H:i') >= $startDateTime->format('Y-m-d H:i'));
    //     // die();
    //     if ($result) {
    //         foreach ($result as $k => $v) {
    //             $startDateTime = new DateTime($result[$k]['date_of_homework'] . $result[$k]['start_time']);
    //             $endDateTime = new DateTime($result[$k]['date_of_submission'] . $result[$k]['end_time']);
    //             $date_of_submission  = $result[$k]['date_of_submission'];
    //             $date = Date('Y-m-d');
    //             $count = $this->db->where(array('homework_id' => $result[$k]['id'], 'student_id' => $result[$k]['student_id']))
    //                 ->get('homework_student')
    //                 ->num_rows();
    //             if ($count == 1) {
    //                 $result[$k]['exisit'] = true;
    //             }
    //             if ($count == 0) {
    //                 $result[$k]['exisit'] = false;
    //                 if ($endDateTime <=  $currentDateTime) {
    //                     $result[$k]['late'] = true;
    //                 } else {
    //                     $result[$k]['late'] = false;
    //                 }
    //             }
    //             $result[$k]['currentTime'] = $currentDateTime->format('Y-m-d H:i');
    //             $result[$k]['startDateTime'] = $startDateTime->format('Y-m-d H:i');
    //             $result[$k]['endDateTime'] = $endDateTime->format('Y-m-d H:i');
    //         }
    //     }
    //     // die();
    //     return $result;
    // }








    public function getQuizList($studentID, $studentSectionID)
    {
        $this->db->select('quiz.*,CONCAT(s.first_name, " ",s.last_name) as fullname,s.register_no,e.student_id, e.roll,subject.name as subject_name,class.name as class_name,he.remark as ev_remarks,he.marks');
        $this->db->from('quiz');
        $this->db->join('enroll as e', 'e.class_id=quiz.class_id and e.session_id = quiz.session_id', 'inner');
        $this->db->join('quiz_questions', 'quiz_questions.quiz_id = quiz.id', 'right');
        $this->db->join('student as s', 'e.student_id = s.id', 'inner');
        $this->db->join('quiz_evaluation as he', 'he.quiz_id = quiz.id and he.student_id = e.student_id', 'left');
        $this->db->join('subject', 'subject.id = quiz.subject_id', 'left');
        $this->db->join('class', 'class.id = quiz.class_id', 'left');
        $this->db->join('section as sec', 'quiz.section_id LIKE CONCAT(\'%"\', sec.id, \'"%\')', 'left');
        $this->db->where('sec.id', $studentSectionID);
        $this->db->where('e.student_id', $studentID);
        // $this->db->where('quiz.status', 0);
        $this->db->where('quiz.session_id', get_session_id());
        $this->db->order_by('quiz.id', 'desc');
        $result = $this->db->get()->result_array();
        $currentDateTime = new DateTime(date('Y-m-d') . date("H:i"));
        // print_r($startDateTime->format('Y-m-d H:i'));
        // var_dump($currentDateTime->format('Y-m-d H:i') >= $startDateTime->format('Y-m-d H:i'));
        // die();

        if ($result) {
            foreach ($result as $k => $v) {
                $startDateTime = new DateTime($result[$k]['publish_date'] . $result[$k]['start_time']);
                $endDateTime = new DateTime($result[$k]['expire_date'] . $result[$k]['end_time']);
                $date_of_submission  = $result[$k]['expire_date'];
                $date = Date('Y-m-d');
                $count = $this->db->where(array('quiz_id' => $result[$k]['id'], 'student_id' => $result[$k]['student_id']))
                    ->get('quiz_student')
                    ->num_rows();
                if ($currentDateTime <  $startDateTime) {
                    $result[$k]['quizStatus'] = false;
                } else {
                    $result[$k]['quizStatus'] = true;
                    if ($count == 1) {
                        $result[$k]['exisit'] = true;
                    }
                    if ($count == 0) {
                        $result[$k]['exisit'] = false;
                        if ($endDateTime <=  $currentDateTime) {
                            $result[$k]['late'] = true;
                        } else {
                            $result[$k]['late'] = false;
                        }
                    }
                }

                $result[$k]['currentTime'] = $currentDateTime->format('Y-m-d H:i');
                $result[$k]['startDateTime'] = $startDateTime->format('Y-m-d H:i');
                $result[$k]['endDateTime'] = $endDateTime->format('Y-m-d H:i');
            }
        }
        return $result;
    }
    function getQuiz($id)
    {
        $this->db->select('quiz_questions.*,q.quiz_setting as setting');
        $this->db->from('quiz_questions');
        $this->db->join('quiz as q', 'quiz_questions.quiz_id=q.id', 'left');
        $this->db->where('quiz_id', $id);
        $result = $this->db->get()->result_array();
        if (empty($result)) {
            return false;
        }
        $result[0]['questions'] = str_replace("'", "\'", $result[0]['questions']);
        return $result;
    }
    function quizSubmit($studentID, $quizID, $quizQuestionID, $aAnswer = array())
    {
        $quiz = $this->getQuiz($quizID);
        $aQuestions = $quiz[0]['questions'];
        $aQuestions = str_replace("\'", "'", $aQuestions);
        $aQuestions = json_decode($aQuestions, true);
        if (!(isset($_POST['step']))&&(!$_POST)) {
            $aQuizSubmit = array(
                'quiz_id' => $quizID,
                'quiz_question_id' => $quizQuestionID,
                'student_id' => $studentID,
                // 'answer' => json_encode($aAnswer),
                'create_date' => date("Y-m-d"),
            );
            $this->db->insert('quiz_student', $aQuizSubmit);
            // $insertedID = $this->db->select('MAX(id) as id')
            //     ->where(array('student_id' => $studentID))
            //     ->get('quiz_student')
            //     ->result_array();
            // $this->session->set_userdata(array(
            //     'quiz_id' . $quizID => $this->db->insert_id() // $insertedID[0]['id']
            // ));
        } else {

            $insertedID = $this->db->select('MAX(id) as id')
                ->where(array('student_id' => $studentID))
                ->get('quiz_student')
                ->result_array();
            unset($aAnswer['step']);
            $aQuizSubmit = array(
                'quiz_id' => $quizID,
                'quiz_question_id' => $quizQuestionID,
                'student_id' => $studentID,
                'answer' => json_encode($aAnswer),
                'create_date' => date("Y-m-d"),
            );
            // if (sizeof($aAnswer) == 1 && !array_key_exists('answer', $aAnswer['question1'])) {
            //     $this->db->where('id', $insertedID);
            //     $this->db->update('quiz_student', $aQuizSubmit);
            //     // $aAnswer['question1']['answer'] = 'not attempted';
            //     return false;
            // }
            // if (sizeof($aQuestions) != sizeof($aAnswer)) {
            //     $this->db->where('id', $insertedID);
            //     $this->db->update('quiz_student', $aQuizSubmit);
                // foreach ($aQuestions as $k => $v) {
                //     if (array_key_exists($k, $aAnswer)) {
                //         if (!array_key_exists('answer', $aAnswer[$k])) {
                //             $aAnswer[$k]['answer'] = 'not attempted';
                //         }
                //     }
                //     // 
                //     if (!array_key_exists($k, $aAnswer)) {
                //         $aAnswer[$k]['type'] = $aQuestions[$k]['type'];
                //         $aAnswer[$k]['answer'] = 'not attempted';
                //     }
                // }
            //     return false;
            // }
            // foreach ($aAnswer as $k => $v) {
            //     if ($v['type'] == 'mcqs' || $v['type'] == 't/f' || $v['type'] == 'f/b') {
            //         if ($v['type'] == 'f/b') {
            //             $v['answer'] = trim($v['answer']);
            //         }
            //         if ($aQuestions[$k]['answer'] == $v['answer']) {
            //             $aAnswer[$k]['result'] = true;
            //         } else {
            //             $aAnswer[$k]['result'] = false;
            //         }
            //     }
            // }
            $this->db->where('id', $insertedID[0]['id']);
            $this->db->update('quiz_student', $aQuizSubmit);
            // if (sizeof($aQuestions) == sizeof($aAnswer)) {
            //     return true;
            // }
        }
    }
    public function getVideoList($studentID, $studentSectionID)
    {
        // echo $studentID;
        // die();
        $this->db->select('video.*,CONCAT(s.first_name, " ",s.last_name) as fullname,s.register_no,e.student_id, e.roll,subject.name as subject_name,class.name as class_name');
        $this->db->from('video');
        $this->db->join('enroll as e', 'e.class_id=video.class_id and  e.session_id = video.session_id', 'inner');
        $this->db->join('student as s', 'e.student_id = s.id', 'inner');
        $this->db->join('subject', 'subject.id = video.subject_id', 'left');
        $this->db->join('class', 'class.id = video.class_id', 'left');
        $this->db->join('section as sec', 'video.section_id LIKE CONCAT(\'%"\', sec.id, \'"%\')', 'left');
        $this->db->where('sec.id', $studentSectionID);
        $this->db->where('e.student_id', $studentID);
        if (!is_superadmin_loggedin()) {
            $this->db->where('video.branch_id', get_loggedin_branch_id());
        }
        $this->db->where('video.status', 0);
        $this->db->where('video.session_id', get_session_id());
        $this->db->order_by('video.id', 'desc');
        return $this->db->get()->result_array();
    }
    public function upload_homework($aPost, $aData)
    {
        $aData['homework_id'] = $aPost['homework_id'];
        $fileInfo = pathinfo($_FILES["attachment_file"]["name"]);
        if (isset($_FILES["attachment_file"]) && !empty($_FILES['attachment_file']['name'])) {
            if (!file_exists('./uploads/attachments/homework_upload/' . $aData["homework_id"] . '')) {
                mkdir('./uploads/attachments/homework_upload/' . $aData["homework_id"] . '', 0777, true);
            }
            $uploaddir = './uploads/attachments/homework_upload/' . $aData["homework_id"] . '/';
            if (!is_dir($uploaddir) && !mkdir($uploaddir)) {
                die("Error creating folder $uploaddir");
            }
            $file_name = $aData['student_name'] . '(' . $aData['classSection'] . ').' . $fileInfo['extension'];
            move_uploaded_file($_FILES["attachment_file"]["tmp_name"], $uploaddir . $file_name);
        }
        $arrayHomework = array(
            'student_id' => $aData['student_id'],
            'homework_id' => $aData['homework_id'],                                                                                      ['homework_id'],
            'upload_file' => $file_name,
        );
        unset($arrayHomework[0]);
        $this->db->insert('homework_student', $arrayHomework);
    }
    public function getVocherList($gr){
        $this->db->select('voucher_data.*');
        $this->db->from('voucher_data');
        $this->db->where('gr_no', $gr);
        return $this->db->get()->result_array();
    }
}
