<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Download_pdf_model extends MY_Model
{

    public function __construct()
    {
        parent::__construct();
    }
    public function pdf(array $aData)
    {
        if (!isset($aData['branch_id'])) {
            $aData['branch_id'] = get_loggedin_branch_id();
        }
        $aBranch = $this->db->select('name')
            ->from('branch')
            ->where(array('id' => $aData['branch_id']))
            ->get()
            ->result_array();
        $branchName =  $aBranch[0]['name'];
        if ($aData['register_no'] == '') {
            $selClass = $this->class('id', $aData['class_id'], ['name', 'name_numeric']);
            $sLike = false;
            $aCon = ['One', 'Two', 'Three', 'Four', 'Five'];
            if (in_array($selClass[0]['name'], $aCon)) {
                $sLike = $branchName;
            } else {
                if (strpos($selClass[0]['name'], '(O/L)') !== false) {
                    $sLike = 'O LEVELS';
                } else if (strpos($selClass[0]['name'], '(M)') !== false) {
                    $sLike = 'MATRICULATION';
                }
            }
            if ($aData['section_id'] != '') {
                $selSec = $this->section('id', $aData['section_id'], ['name'], $aData['branch_id']);
            }
        }
        // echo '<pre>';
        // print_r($selSec[0]['name']);
        // die();
        // print_r($aData);
        $aPdfData = [];

        $this->db->select('*')
            ->from('voucher_data')
            ->where('campus', $branchName)

            ->order_by('campus,class_sep,section,gr_Index');
        // ->order_by('');
        if ($aData['register_no'] == '') {
            if ($aData['section_id'] != '') {
                $this->db->where('section', $selSec[0]['name']);
            }
            if ($sLike) {
                $this->db->like('class', $sLike)
                    ->where('class_sep', $selClass[0]['name_numeric']);
            } else {
                $this->db->like('class', $selClass[0]['name']);
            }
        } else {
            $this->db->where('gr_no', $aData['register_no']);
        }
        $aVocherData =  $this->db->get()->result_array(); //get_compiled_select

        if (!$aVocherData) {
            return [
                'success' => false,
                'msg' => 'no_record_found'
            ];
        }
        // print_r($aVocherData);
        foreach ($aVocherData as $k => $v) {
            $code = '';
            if ($v['campus'] == 'MONTESSORI') {
                $code .= '71';
            } else {
                $code .= '72';
            }
            $code .= sprintf("%05d", $v['voucher_no']);
            $code .= sprintf("%04d", $v['gr_no']);
            $code .= sprintf("%05d", $v['total']);
            $code .= $this->dateConversion($v['due_date']);
            $code .= sprintf("%05d", ($v['total'] + 300));
            $code .= $this->dateConversion($v['valid_date']);
            $aVocherData[$k]['barcode'] = $this->generateBarcode($code);
        }
        // $aPdfData['aVocherData'] = $aVocherData;
        $this->load->library('pdf');
        return $this->pdf->load_view('voucher/index', $aVocherData, $aData);
        // echo '<pre>';
        // print_r($aVocherData);
        // die();
    }
    private function generateBarcode($code = '')
    {
        //load library
        $this->load->library('zend');
        //load in folder Zend
        $this->zend->load('Zend/Barcode');
        $barcode = Zend_Barcode::factory('code128', 'image', array('text' => $code, 'barHeight' => 30, 'factor' => 1), array('imageType' => 'png'));
        $path = FCPATH . $code . '.gif';
        imagegif($barcode->draw(), $path);
        $code_img_base64 = base64_encode(file_get_contents($path));
        unlink($path);
        return $code_img_base64;
    }
    private function dateConversion($date)
    {
        $aDate = explode('-', $date);
        return  sprintf("%02d", $aDate[0]) . date('m', strtotime($aDate[1])) . $aDate[2];
    }
    function class($key, $val, $aField)
    {
        $aClassDb = $this->db->select($aField)
            ->from('class')
            ->where(array($key => $val))
            ->get()
            ->result_array();
        return $aClassDb;
    }
    function section($key, $val, $aField, $branch)
    {
        $aSectionDb = $this->db->select($aField)
            ->from('section')
            ->where(array($key => $val, 'branch_id' => $branch))
            ->get()
            ->result_array();
        // $querry = $this->db->where(array('name' => $name, 'branch_id' => $branch))->get_compiled_select('section');
        // print_r($querry);
        return $aSectionDb;
    }
}
