<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @package : Ramom school management system
 * @version : 2.0
 * @developed by : RamomCoder
 * @support : ramomcoder@yahoo.com
 * @author url : http://codecanyon.net/user/RamomCoder
 * @filename : video.php
 * @copyright : Reserved RamomCoders Team
 */

class Video extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('video_model');
        $this->load->model('sms_model');
    }

    public function index()
    {
        // check access permission
        if (!get_permission('video', 'is_view')) {
            access_denied();
        }

        $branchID = $this->application_model->get_branch_id();
        if ($_POST) {
            $classID = $this->input->post('class_id');
            // $sectionID = $this->input->post('section_id');
            $subjectID = $this->input->post('subject_id');
            $this->data['videolist'] = $this->video_model->getList($classID, $branchID);
        }
        
        $this->data['branch_id'] = $branchID;
        $this->data['title'] = translate('video');
        $this->data['sub_page'] = 'video/index';
        $this->data['main_menu'] = 'video';
        $this->load->view('layout/index', $this->data);
    }

    public function add()
    {
        if (!get_permission('video', 'is_add')) {
            access_denied();
        }
        if ($_POST) {
            $this->video_validation();
            if ($this->form_validation->run() !== false) {
                $post = $this->input->post();
                $response = $this->video_model->save($post);
                set_alert('success', translate('information_has_been_saved_successfully'));
                $url = base_url('video');
                $array = array('status' => 'success', 'url' => $url);
            } else {
                $error = $this->form_validation->error_array();
                $array = array('status' => 'fail','error' => $error);
            }
            echo json_encode($array);
            exit();
        }
        
        $this->data['branch_id'] = $this->application_model->get_branch_id();
        $this->data['title'] = translate('video');
        $this->data['sub_page'] = 'video/add';
        $this->data['main_menu'] = 'video';
        $this->data['headerelements'] = array(
            'css' => array(
                'vendor/summernote/summernote.css',
                'vendor/bootstrap-fileupload/bootstrap-fileupload.min.css',
            ),
            'js' => array(
                'vendor/summernote/summernote.js',
                'vendor/bootstrap-fileupload/bootstrap-fileupload.min.js',
            ),
        );
        $this->load->view('layout/index', $this->data);
    }

    public function edit($id='')
    {
        if (!get_permission('video', 'is_edit')) {
            access_denied();
        }
        
        if ($_POST) {
            $this->video_validation();
            if ($this->form_validation->run() !== false) {
                $post = $this->input->post();
                $response = $this->video_model->save($post);
                set_alert('success', translate('information_has_been_updated_successfully'));
                $url = base_url('video');
                $array = array('status' => 'success', 'url' => $url);
            } else {
                $error = $this->form_validation->error_array();
                $array = array('status' => 'fail','error' => $error);
            }
            echo json_encode($array);
            exit();
        }
        
        $this->data['video'] = $this->app_lib->getTable('video', array('t.id' => $id), true);
        $this->data['branch_id'] = $this->application_model->get_branch_id();;
        $this->data['title'] = translate('video');
        $this->data['sub_page'] = 'video/edit';
        $this->data['main_menu'] = 'video';
        $this->data['headerelements'] = array(
            'css' => array(
                'vendor/summernote/summernote.css',
                'vendor/bootstrap-fileupload/bootstrap-fileupload.min.css',
            ),
            'js' => array(
                'vendor/summernote/summernote.js',
                'vendor/bootstrap-fileupload/bootstrap-fileupload.min.js',
            ),
        );
        $this->load->view('layout/index', $this->data);
    }

    public function delete($id = '')
    {
        if (get_permission('video', 'is_delete') && !empty($id)) {
            if (!is_superadmin_loggedin()) {
                $this->db->where('branch_id', get_loggedin_branch_id());
            }
            $this->db->where('id', $id);
            $this->db->delete('video');
        }
    }

    /* video form validation rules */
    protected function video_validation()
    {
        if (is_superadmin_loggedin()) {
            $this->form_validation->set_rules('branch_id', translate('branch'), 'required');
        }
        $this->form_validation->set_rules('class_id', translate('class'), 'trim|required');
        $this->form_validation->set_rules('section[]', translate('section'), 'trim|required');
        $this->form_validation->set_rules('subject_id', translate('subject'), 'trim|required');
        $this->form_validation->set_rules('description', translate('description'), 'trim');
        $this->form_validation->set_rules('url', translate('url'), 'required');
        $this->form_validation->set_rules('publish_date', translate('publish_date'), 'required');
        $this->form_validation->set_rules('expire_date', translate('expire_date'), 'required');
    }
}
