<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @package : Ramom school management system
 * @version : 2.0
 * @developed by : RamomCoder
 * @support : ramomcoder@yahoo.com
 * @author url : http://codecanyon.net/user/RamomCoder
 * @filename : Accounting.php
 * @copyright : Reserved RamomCoders Team
 */

class Userrole extends User_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('userrole_model');
        $this->load->model('leave_model');
        $this->load->model('fees_model');
        $this->load->model('exam_model');
        $this->load->library('user_agent');
    }

    public function index()
    {
        redirect(base_url(), 'refresh');
    }

    /* getting all teachers list */
    public function teachers()
    {
        $this->data['title'] = translate('teachers');
        $this->data['sub_page'] = 'userrole/teachers';
        $this->data['main_menu'] = 'teachers';
        $this->load->view('layout/index', $this->data);
    }

    public function subject()
    {
        $this->data['title'] = translate('subject');
        $this->data['sub_page'] = 'userrole/subject';
        $this->data['main_menu'] = 'academic';
        $this->load->view('layout/index', $this->data);
    }

    /* student or parent timetable preview page */
    public function class_schedule()
    {
        $stu = $this->userrole_model->getStudentDetails();
        $arrayTimetable = array(
            'class_id' => $stu['class_id'],
            'section_id' => $stu['section_id'],
            'session_id' => get_session_id(),
        );
        $this->db->order_by('time_start', 'asc');
        $this->data['timetables'] = $this->db->get_where('timetable_class', $arrayTimetable)->result();
        $this->data['student'] = $stu;
        $this->data['title'] = translate('class') . " " . translate('schedule');
        $this->data['sub_page'] = 'userrole/class_schedule';
        $this->data['main_menu'] = 'academic';
        $this->load->view('layout/index', $this->data);
    }


    public function leave_request()
    {
        $stu = $this->userrole_model->getStudentDetails();
        if (isset($_POST['save'])) {
            $this->form_validation->set_rules('leave_category', translate('leave_category'), 'required|callback_leave_check');
            $this->form_validation->set_rules('daterange', translate('leave_date'), 'trim|required|callback_date_check');
            $this->form_validation->set_rules('attachment_file', translate('attachment'), 'callback_handle_upload');
            if ($this->form_validation->run() !== false) {
                $leave_type_id  = $this->input->post('leave_category');
                $branch_id      = $this->application_model->get_branch_id();
                $daterange      = explode(' - ', $this->input->post('daterange'));
                $start_date     = date("Y-m-d", strtotime($daterange[0]));
                $end_date       = date("Y-m-d", strtotime($daterange[1]));
                $reason         = $this->input->post('reason');
                $apply_date     = date("Y-m-d H:i:s");
                $datetime1      = new DateTime($start_date);
                $datetime2      = new DateTime($end_date);
                $leave_days     = $datetime2->diff($datetime1)->format("%a") + 1;
                $orig_file_name = '';
                $enc_file_name  = '';
                // upload attachment file
                if (isset($_FILES["attachment_file"]) && !empty($_FILES['attachment_file']['name'])) {
                    $config['upload_path']      = './uploads/attachments/leave/';
                    $config['allowed_types']    = "*";
                    $config['max_size']         = '2024';
                    $config['encrypt_name']     = true;
                    $this->upload->initialize($config);
                    $this->upload->do_upload("attachment_file");
                    $orig_file_name = $this->upload->data('orig_name');
                    $enc_file_name  = $this->upload->data('file_name');
                }
                $arrayData = array(
                    'user_id'           => $stu['student_id'],
                    'role_id'           => 7,
                    'session_id'        => get_session_id(),
                    'category_id'       => $leave_type_id,
                    'reason'            => $reason,
                    'branch_id'         => $branch_id,
                    'start_date'        => date("Y-m-d", strtotime($start_date)),
                    'end_date'          => date("Y-m-d", strtotime($end_date)),
                    'leave_days'        => $leave_days,
                    'status'            => 1,
                    'orig_file_name'    => $orig_file_name,
                    'enc_file_name'     => $enc_file_name,
                    'apply_date'        => $apply_date,
                );
                $this->db->insert('leave_application', $arrayData);
                set_alert('success', translate('information_has_been_saved_successfully'));
                redirect(base_url('userrole/leave_request'));
            }
        }
        $where = array('la.user_id' => $stu['student_id'], 'la.role_id' => 7);
        $this->data['leavelist'] = $this->leave_model->getLeaveList($where);
        $this->data['title'] = translate('leaves');
        $this->data['sub_page'] = 'userrole/leave_request';
        $this->data['main_menu'] = 'leave';
        $this->data['headerelements']   = array(
            'css' => array(
                'vendor/dropify/css/dropify.min.css',
                'vendor/daterangepicker/daterangepicker.css',
            ),
            'js' => array(
                'vendor/dropify/js/dropify.min.js',
                'vendor/moment/moment.js',
                'vendor/daterangepicker/daterangepicker.js',
            ),
        );
        $this->load->view('layout/index', $this->data);
    }

    //  date check for leave request
    public function date_check($daterange)
    {
        $daterange = explode(' - ', $daterange);
        $start_date = date("Y-m-d", strtotime($daterange[0]));
        $end_date = date("Y-m-d", strtotime($daterange[1]));
        $today = date('Y-m-d');
        if ($today == $start_date) {
            $this->form_validation->set_message('date_check', "You can not leave the current day.");
            return false;
        }
        if ($this->input->post('applicant_id')) {
            $applicant_id = $this->input->post('applicant_id');
            $role_id = $this->input->post('user_role');
        } else {
            $applicant_id = get_loggedin_user_id();
            $role_id = loggedin_role_id();
        }
        $getUserLeaves = $this->db->get_where('leave_application', array('user_id' => $applicant_id, 'role_id' => $role_id))->result();
        if (!empty($getUserLeaves)) {
            foreach ($getUserLeaves as $user_leave) {
                $get_dates = $this->user_leave_days($user_leave->start_date, $user_leave->end_date);
                $result_start = in_array($start_date, $get_dates);
                $result_end = in_array($end_date, $get_dates);
                if (!empty($result_start) || !empty($result_end)) {
                    $this->form_validation->set_message('date_check', 'Already have leave in the selected time.');
                    return false;
                }
            }
        }
        return true;
    }

    public function leave_check($type_id)
    {
        if (!empty($type_id)) {
            $daterange = explode(' - ', $this->input->post('daterange'));
            $start_date = date("Y-m-d", strtotime($daterange[0]));
            $end_date = date("Y-m-d", strtotime($daterange[1]));

            if ($this->input->post('applicant_id')) {
                $applicant_id = $this->input->post('applicant_id');
                $role_id = $this->input->post('user_role');
            } else {
                $applicant_id = get_loggedin_user_id();
                $role_id = loggedin_role_id();
            }
            if (!empty($start_date) && !empty($end_date)) {
                $leave_total = get_type_name_by_id('leave_category', $type_id, 'days');
                $total_spent = $this->db->select('IFNULL(SUM(leave_days), 0) as total_days')
                    ->where(array('user_id' => $applicant_id, 'role_id' => $role_id, 'category_id' => $type_id, 'status' => '2'))
                    ->get('leave_application')->row()->total_days;

                $datetime1 = new DateTime($start_date);
                $datetime2 = new DateTime($end_date);
                $leave_days = $datetime2->diff($datetime1)->format("%a") + 1;
                $left_leave = ($leave_total - $total_spent);
                if ($left_leave < $leave_days) {
                    $this->form_validation->set_message('leave_check', "Applyed for $leave_days days, get maximum $left_leave Days days.");
                    return false;
                } else {
                    return true;
                }
            } else {
                $this->form_validation->set_message('leave_check', "Select all required field.");
                return false;
            }
        }
    }

    public function user_leave_days($start_date, $end_date)
    {
        $dates      = array();
        $current    = strtotime($start_date);
        $end_date   = strtotime($end_date);
        while ($current <= $end_date) {
            $dates[] = date('Y-m-d', $current);
            $current = strtotime('+1 day', $current);
        }
        return $dates;
    }

    public function handle_upload()
    {
        if (isset($_FILES["attachment_file"]) && !empty($_FILES['attachment_file']['name'])) {
            $file_type      = $_FILES["attachment_file"]['type'];
            $file_size      = $_FILES["attachment_file"]["size"];
            $file_name      = $_FILES["attachment_file"]["name"];
            $allowedExts    = array('pdf', 'doc', 'xls', 'docx', 'xlsx', 'jpg', 'jpeg', 'png', 'gif', 'bmp');
            $upload_size    = 2097152;
            $extension      = pathinfo($file_name, PATHINFO_EXTENSION);
            if ($files = filesize($_FILES['attachment_file']['tmp_name'])) {
                if (!in_array(strtolower($extension), $allowedExts)) {
                    $this->form_validation->set_message('handle_upload', translate('this_file_type_is_not_allowed'));
                    return false;
                }
                if ($file_size > $upload_size) {
                    $this->form_validation->set_message('handle_upload', translate('file_size_shoud_be_less_than') . " " . ($upload_size / 1024) . " KB");
                    return false;
                }
            } else {
                $this->form_validation->set_message('handle_upload', translate('error_reading_the_file'));
                return false;
            }
            return true;
        } else {
            return true;
        }
    }

    public function attachments()
    {
        $this->data['title'] = translate('attachments');
        $this->data['sub_page'] = 'userrole/attachments';
        $this->data['main_menu'] = 'attachments';
        $this->load->view('layout/index', $this->data);
    }

    /* exam timetable preview page */
    public function exam_schedule()
    {
        $stu = $this->userrole_model->getStudentDetails();
        $this->data['student'] = $stu;
        $this->data['exams'] = $this->db->get_where('timetable_exam', array(
            'class_id' => $stu['class_id'],
            'section_id' => $stu['section_id'],
            'session_id' => get_session_id(),
        ))->result_array();
        $this->data['title'] = translate('exam') . " " . translate('schedule');
        $this->data['sub_page'] = 'userrole/exam_schedule';
        $this->data['main_menu'] = 'exam';
        $this->load->view('layout/index', $this->data);
    }

    /* hostels user interface */
    public function hostels()
    {
        $this->data['student'] = $this->userrole_model->getStudentDetails();
        $this->data['title'] = translate('hostels');
        $this->data['sub_page'] = 'userrole/hostels';
        $this->data['main_menu'] = 'supervision';
        $this->load->view('layout/index', $this->data);
    }

    /* route user interface */
    public function route()
    {
        $stu = $this->userrole_model->getStudentDetails();
        $this->data['route'] = $this->userrole_model->getRouteDetails($stu['route_id'], $stu['vehicle_id']);
        $this->data['title'] = translate('route_master');
        $this->data['sub_page'] = 'userrole/transport_route';
        $this->data['main_menu'] = 'supervision';
        $this->load->view('layout/index', $this->data);
    }

    /* after login students or parents produced reports here */
    public function attendance()
    {
        if ($this->input->post('submit') == 'search') {
            $this->data['month'] = date('m', strtotime($this->input->post('timestamp')));
            $this->data['year'] = date('Y', strtotime($this->input->post('timestamp')));
            $this->data['days'] = cal_days_in_month(CAL_GREGORIAN, $this->data['month'], $this->data['year']);
            $this->data['student'] = $this->userrole_model->getStudentDetails();
        }
        $this->data['title'] = translate('student_attendance');
        $this->data['sub_page'] = 'userrole/attendance';
        $this->data['main_menu'] = 'attendance';
        $this->load->view('layout/index', $this->data);
    }


    // book page
    public function book()
    {
        $this->data['booklist'] = $this->app_lib->getTable('book');
        $this->data['title'] = translate('books');
        $this->data['sub_page'] = 'userrole/book';
        $this->data['main_menu'] = 'library';
        $this->load->view('layout/index', $this->data);
    }

    public function book_request()
    {
        $stu = $this->userrole_model->getStudentDetails();
        if ($_POST) {
            $this->form_validation->set_rules('book_id', translate('book_title'), 'required|callback_validation_stock');
            $this->form_validation->set_rules('date_of_issue', translate('date_of_issue'), 'trim|required');
            $this->form_validation->set_rules('date_of_expiry', translate('date_of_expiry'), 'trim|required|callback_validation_date');
            if ($this->form_validation->run() !== false) {
                $arrayIssue = array(
                    'branch_id' => $stu['branch_id'],
                    'book_id' => $this->input->post('book_id'),
                    'user_id' => $stu['student_id'],
                    'role_id' => 7,
                    'date_of_issue' => date("Y-m-d", strtotime($this->input->post('date_of_issue'))),
                    'date_of_expiry' => date("Y-m-d", strtotime($this->input->post('date_of_expiry'))),
                    'issued_by' => get_loggedin_user_id(),
                    'status' => 0,
                    'session_id' => get_session_id(),
                );
                $this->db->insert('book_issues', $arrayIssue);
                set_alert('success', translate('information_has_been_saved_successfully'));
                $this->data['url']  = base_url('userrole/book_request');
                $array = array('status' => 'success', 'url' => $this->data['url'], 'error' => '');
            } else {
                $error = $this->form_validation->error_array();
                $array = array('status' => 'fail', 'url' => '', 'error' => $error);
            }
            echo json_encode($array);
            exit();
        }
        $this->data['stu'] = $stu;
        $this->data['title'] = translate('library');
        $this->data['sub_page'] = 'userrole/book_request';
        $this->data['main_menu'] = 'library';
        $this->load->view('layout/index', $this->data);
    }

    // book date validation
    public function validation_date($date)
    {
        if ($date) {
            $date = strtotime($date);
            $today = strtotime(date('Y-m-d'));
            if ($today >= $date) {
                $this->form_validation->set_message("validation_date", translate('today_or_the_previous_day_can_not_be_issued'));
                return false;
            } else {
                return true;
            }
        }
    }

    // validation book stock
    public function validation_stock($book_id)
    {
        $query = $this->db->select('total_stock,issued_copies')->where('id', $book_id)->get('book')->row_array();
        $stock = $query['total_stock'];
        $issued = $query['issued_copies'];
        if ($stock == 0 || $issued >= $stock) {
            $this->form_validation->set_message("validation_stock", translate('the_book_is_not_available_in_stock'));
            return false;
        } else {
            return true;
        }
    }

    public function event()
    {
        $branchID = $this->application_model->get_branch_id();
        $this->data['branch_id'] = $branchID;
        $this->data['title'] = translate('events');
        $this->data['sub_page'] = 'userrole/event';
        $this->data['main_menu'] = 'event';
        $this->load->view('layout/index', $this->data);
    }

    /* invoice user interface with information are controlled here */
    public function invoice()
    {
        $stu = $this->userrole_model->getStudentDetails();
        $this->data['config'] = $this->get_payment_config();
        $this->data['invoice'] = $this->fees_model->getInvoiceStatus($stu['student_id']);
        $this->data['basic'] = $this->fees_model->getInvoiceBasic($stu['student_id']);
        $this->data['title'] = translate('fees_history');
        $this->data['main_menu'] = 'fees';
        $this->data['sub_page'] = 'userrole/collect';
        $this->load->view('layout/index', $this->data);
    }

    /* invoice user interface with information are controlled here */
    public function report_card()
    {
        $this->data['stu'] = $this->userrole_model->getStudentDetails();
        $this->data['title'] = translate('exam_master');
        $this->data['main_menu'] = 'exam';
        $this->data['sub_page'] = 'userrole/report_card';
        $this->load->view('layout/index', $this->data);
    }

    public function homework()
    {
        $stu = $this->userrole_model->getStudentDetails();
        $homeworklist = $this->userrole_model->getHomeworkList($stu['student_id'], $stu['section_id']);
        $this->data['homeworklist'] = $homeworklist;
        $this->data['headerelements'] = array(
            'css' => array(
                'vendor/summernote/summernote.css',
                'vendor/bootstrap-fileupload/bootstrap-fileupload.min.css',
            ),
            'js' => array(
                'vendor/summernote/summernote.js',
                'vendor/bootstrap-fileupload/bootstrap-fileupload.min.js',
            ),
        );

        if (isset($_FILES["attachment_file"]) && !empty($_FILES['attachment_file']['name'])) {
            $this->form_validation->set_rules('attachment_file', translate('attachment'), 'callback_handle_upload');
            $aPost = $this->input->post();
            if ($this->form_validation->run() !== false) {
                $aData = array(
                    'student_id' => $homeworklist[0]['student_id'],
                    'student_name' => $stu['fullname'],
                    'classSection' => $stu['class_name'] . '-' . $stu['section_name'],
                );
                $this->userrole_model->upload_homework($aPost, $aData);
                set_alert('success', translate('homework_has_been_saved_submitted'));
                $url = base_url('userrole/homework');
                $array = array('status' => 'success', 'url' => $url);
            } else {
                $error = $this->form_validation->error_array();
                $array = array('status' => 'fail', 'error' => $error);
            }
            echo json_encode($array);
            exit();
        }
        $this->data['section_name'] = $stu['section_name'];
        $this->data['title'] = translate('homework');
        $this->data['main_menu'] = 'homework';
        $this->data['sub_page'] = 'userrole/homework';
        $this->load->view('layout/index', $this->data);
    }

    public function quiz()
    {
        $stu = $this->userrole_model->getStudentDetails();
        $quizlist = $this->userrole_model->getQuizList($stu['student_id'], $stu['section_id']);
        $this->data['quizlist'] = $quizlist;
        $this->data['headerelements'] = array(
            'css' => array(
                'vendor/summernote/summernote.css',
                'vendor/bootstrap-fileupload/bootstrap-fileupload.min.css',
            ),
            'js' => array(
                'vendor/summernote/summernote.js',
                'vendor/bootstrap-fileupload/bootstrap-fileupload.min.js',
            ),
        );
        $this->data['section_name'] = $stu['section_name'];
        $this->data['title'] = translate('quiz');
        $this->data['main_menu'] = 'quiz';
        $this->data['sub_page'] = 'userrole/quiz';
        $this->load->view('layout/index', $this->data);
    }

    function getquiz($id = '')
    {
        $stu = $this->userrole_model->getStudentDetails();
        $count = $this->db->where(array('quiz_id' => $id, 'student_id' => $stu['student_id']))
            ->get('quiz_student')
            ->num_rows();
        $sectionCheck = $this->db->where(array('id' => $id))->like('section_id', $stu['section_id']) //->get_compiled_select('quiz');
            ->get('quiz')
            ->num_rows();
        $quiz = $this->userrole_model->getQuiz($id);

        $quizQuestions=json_decode($quiz[0]['questions'],TRUE);
        
        $totalQuestions=0;
        foreach ( $quizQuestions as $key => $value) {
            $totalQuestions++;
            $quiz[0]['totalQuestions']=$totalQuestions;
        }

        $counter = $this->db->select('quiz_time')
            ->where(array('id' => $id)) //->get_compiled_select('quiz');
            ->get('quiz')
            ->result_array();
        $this->data['counter'] = $counter[0]['quiz_time'];
        $this->data['quiz'] = $quiz;
        $this->data['quiz'][0]['setting'] = json_decode($this->data['quiz'][0]['setting'], true);
        if (!$_POST) {
            if ($count == 1) {
                access_denied();
            }
            if ($sectionCheck == 0) {
                access_denied();
            }
            $this->userrole_model->quizSubmit($stu['student_id'], $id, $quiz[0]['id']);
        }
        if ($_POST) {
            $aPost = $this->input->post();
            $this->userrole_model->quizSubmit($stu['student_id'], $id, $quiz[0]['id'], $aPost);
            $reponse = false;
            if (!(isset($_POST['step']))) {
                $reponse = true;
            }
            if ($reponse) {
                set_alert('success', translate('quiz_has_been_submitted'));
                $url = base_url('userrole/quiz');
                $array = array('status' => 'success', 'url' => $url);
            }
            echo json_encode($array);
            exit();
        }
        $this->data['headerelements'] = array(
            'css' => array(
                'vendor/summernote/summernote.css',
                'vendor/bootstrap-fileupload/bootstrap-fileupload.min.css',
            ),
            'js' => array(
                'vendor/summernote/summernote.js',
                'vendor/jquery-counter/jquery.countdown.js',
                'vendor/bootstrap-fileupload/bootstrap-fileupload.min.js',
            ),
        );
        $this->data['section_name'] = $stu['section_name'];
        $this->data['title'] = translate('quiz');
        $this->data['main_menu'] = 'quiz';
        $this->data['sub_page'] = 'userrole/getquiz';
        $this->load->view('layout/index', $this->data);
    }
    public function video()
    {
        $stu = $this->userrole_model->getStudentDetails();
        $this->data['videolist'] = $this->userrole_model->getVideoList($stu['student_id'], $stu['section_id']);
        $this->data['section_name'] = $stu['section_name'];
        $this->data['title'] = translate('video');
        $this->data['main_menu'] = 'video';
        $this->data['sub_page'] = 'userrole/video';
        $this->load->view('layout/index', $this->data);
    }

    public function live_class()
    {
        if (!is_student_loggedin()) {
            access_denied();
        }
        $this->data['branch_id'] = $this->application_model->get_branch_id();
        $this->data['title'] = translate('live_class_rooms');
        $this->data['sub_page'] = 'userrole/live_class';
        $this->data['main_menu'] = 'live_class';
        $this->load->view('layout/index', $this->data);
    }

    public function joinModal()
    {
        if (!is_student_loggedin()) {
            access_denied();
        }

        $this->data['meetingID'] = $this->input->post('meeting_id');
        if ($this->agent->platform() == 'Mac OS X') {
            $this->data['url'] = 'https://zoom.us/support/download';
            $this->data['os'] = 'm';
        }
        if (substr($this->agent->platform(), 0, 6) == 'Window') {
            $this->data['url'] = 'https://zoom.us/support/download';
            $this->data['os'] = 'w';
        }
        if ($this->agent->mobile() == 'Android') {
            $this->data['url'] = 'https://play.google.com/store/apps/details?id=us.zoom.videomeetings&hl=en';
            $this->data['os'] = 'a';
        }
        if ($this->agent->mobile() == 'Apple iPhone') {
            $this->data['url'] = 'https://apps.apple.com/us/app/zoom-cloud-meetings/id546505307';
            $this->data['os'] = 'i';
        }
        echo $this->load->view('userrole/live_classModal', $this->data, true);
    }

    public function livejoin()
    {
        if (!is_student_loggedin()) {
            access_denied();
        }
        $meetingID = $this->input->get('meeting_id', true);
        $liveID = $this->input->get('live_id', true);
        if (empty($meetingID) || empty($liveID)) {
            access_denied();
        }
        $this->load->view('userrole/livejoin', $this->data);
    }

    public function __voucher()
    {
        $stu = $this->userrole_model->getStudentDetails();
        // $this->data['voucherlist'] = $this->userrole_model->getVoucherList($stu['student_id']);
        // $this->data['voucherlist']
        $this->data['voucherlist'] = $this->getFilesByGrNo(FCPATH . 'uploads/vouchers/', $stu['register_no']);
        $this->data['title'] = translate('voucher');
        $this->data['main_menu'] = 'voucher';
        $this->data['sub_page'] = 'userrole/voucher';
        $this->load->view('layout/index', $this->data);
    }
    public function voucher()
    {
        $stu = $this->userrole_model->getStudentDetails();
        // $this->data['voucherlist'] = $this->userrole_model->getVoucherList($stu['student_id']);
        // $this->data['voucherlist']
        // $this->data['voucherlist'] = $this->getFilesByGrNo(FCPATH . 'uploads/vouchers/', $stu['register_no']);
        $this->data['voucherlist'] = $this->userrole_model->getVocherList($stu['register_no']);
        $this->data['title'] = translate('voucher');
        $this->data['main_menu'] = 'voucher';
        $this->data['sub_page'] = 'userrole/voucher';
        $this->load->view('layout/index', $this->data);
    }
    public function pdf($id  = '')
    {
        $this->load->model('userrole_model');
        $aVocherData['aVocherData'] = $this->userrole_model->getVocherList($id);
        $aData = $aVocherData['aVocherData'][0];
        $code = '';
        if ($aData['campus'] == 'MONTESSORI') {
            $code .= '71';
        } else {
            $code .= '72';
        }
        $code .= sprintf("%05d", $aData['voucher_no']);
        $code .= sprintf("%04d", $aData['gr_no']);
        $code .= sprintf("%05d", $aData['total']);
        $code .= $this->dateConversion($aData['due_date']);
        $code .= sprintf("%05d", ($aData['total'] + 300));
        $code .= $this->dateConversion($aData['valid_date']);
        $aVocherData['aVocherData'][0]['barcode'] = $this->generateBarcode($code);
        $this->load->library('pdf');
        $this->pdf->load_view('voucher/index-mezn', $aVocherData['aVocherData']);
    }
    // public function pdf_bahl($id  = '')
    // {
    //     $this->load->model('userrole_model');
    //     $aVocherData['aVocherData'] = $this->userrole_model->getVocherList($id);
    //     $aData = $aVocherData['aVocherData'][0];
    //     $code = '';
    //     if ($aData['campus'] == 'MONTESSORI') {
    //         $code .= '71';
    //     } else {
    //         $code .= '72';
    //     }
    //     $code .= sprintf("%05d", $aData['voucher_no']);
    //     $code .= sprintf("%04d", $aData['gr_no']);
    //     $code .= sprintf("%05d", $aData['total']);
    //     $code .= $this->dateConversion($aData['due_date']);
    //     $code .= sprintf("%05d", ($aData['total'] + 300));
    //     $code .= $this->dateConversion($aData['valid_date']);
    //     $aVocherData['aVocherData'][0]['barcode'] = $this->generateBarcode($code);
    //     $this->load->library('pdf');
    //     $this->pdf->load_view('voucher/index-bahl', $aVocherData['aVocherData']);
    // }
    private function generateBarcode($code = '')
    {
        //load library
        $this->load->library('zend');
        //load in folder Zend
        $this->zend->load('Zend/Barcode');
        $barcode = Zend_Barcode::factory('code128', 'image', array('text' => $code, 'barHeight' => 30, 'factor' => 1), array('imageType' => 'png'));
        $path = FCPATH . $code . '.gif';
        imagegif($barcode->draw(), $path);
        $code_img_base64 = base64_encode(file_get_contents($path));
        unlink($path);
        return $code_img_base64;
    }
    private function dateConversion($date)
    {
        $aDate = explode('-', $date);
        return  sprintf("%02d", $aDate[0]) . date('m', strtotime($aDate[1])) . $aDate[2];
    }
    //  getFilesByGrNo
    private function getFilesByGrNo($dirPath, $grNo)
    {
        
        $aRes = array();
        $pattern = '/^(' . $grNo . '-[A-Za-z0-9]+(.PDF|.pdf))$/';
        
        if (substr($dirPath, -1) != '/') {
            $dirPath = $dirPath . '/';
        }
        $directory = opendir($dirPath);

        while (($file = readdir($directory)) !== FALSE) {
            if (is_dir($dirPath . $file) && $file != '.' && $file != '..') {
                // echo $dirPath.$file.'-'.$grNo.'<br>';
                // print_r($this->getFilesByGrNo($dirPath.$file.'/', $grNo));
                $aRes = array_merge($this->getFilesByGrNo($dirPath . $file, $grNo), $aRes);
            } else if (!preg_match($pattern, $file)) {
                // echo $file.'<br>';
                continue;
            } else {
                $aRes[] = array(
                    'path' => str_ireplace(FCPATH, base_url(), $dirPath),
                    'fileName' => $file
                );
            }
        }
        return $aRes;
    }
}
