<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @package : Ramom school management system
 * @version : 2.0
 * @developed by : RamomCoder
 * @support : ramomcoder@yahoo.com
 * @author url : http://codecanyon.net/user/RamomCoder
 * @filename : Accounting.php
 * @copyright : Reserved RamomCoders Team
 */

class Update extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->helpers('download');
        $this->load->model('DB_update_model');
    }

    public function index()
    {
        if (!get_permission('update', 'is_view')) {
            access_denied();
        }
        $this->data['sub_page'] = 'database_update/index';
        $this->data['main_menu'] = 'settings';
        $this->data['title'] = translate('database_Update');
        $this->data['headerelements'] = array(
            'css' => array(
                'vendor/dropify/css/dropify.min.css',
            ),
            'js' => array(
                'vendor/dropify/js/dropify.min.js',
            ),
        );
        $this->load->view('layout/index', $this->data);
    }

    public function update_file()
    {
        if (!get_permission('update', 'is_add')) {
            ajax_access_denied();
        }
        $err_msg = "";
        $i = 0;
        $this->load->library('csvimport');
        if (isset($_FILES["userfile"]) && !empty($_FILES['userfile']['name'])) {



            $uploaddir = 'uploads/csv/';
            if (!file_exists($uploaddir) ) {
                if(mkdir($uploaddir,0777,true)){
                    die("Error creating folder  $uploaddir");
               }

           }
            $temp_path=$_FILES["userfile"]["tmp_name"];
            $csv_array = $this->csvimport->get_array($temp_path);
            
            $fileInfo = pathinfo($_FILES["userfile"]["name"]);

            $file_name = "csv_data". '.' . $fileInfo['extension'];

            $full_file_name=$uploaddir . $file_name;
            move_uploaded_file($temp_path,$full_file_name );
            

            $file_name = date("Y_m_d"). '.' . $fileInfo['extension'];

            $full_file_name=$uploaddir . $file_name;
            move_uploaded_file($temp_path,$full_file_name );

         
            if ($csv_array) {
               
                $columnHeaders = array('FirstName', 'LastName', 'BloodGroup', 'Gender', 'Birthday', 'MotherTongue', 'Religion', 'Caste', 'Phone', 'City', 'State', 'PresentAddress', 'PermanentAddress', 'CategoryID', 'Roll', 'AdmissionDate', 'StudentEmail', 'StudentPassword', 'GuardianName', 'GuardianRelation', 'FatherName', 'MotherName', 'GuardianOccupation', 'GuardianMobileNo', 'GuardianAddress', 'GuardianEmail', 'GuardianPassword', 'class','section','campus','board');
                $csvData = array();
                foreach ($csv_array as $row) {
                    if ($i == 0) {
                    
                        $csvData = array_keys($row);
                    }
                    $csv_chk = array_diff($columnHeaders, $csvData);
                    if (count($csv_chk) <= 0) {

                        $this->DB_update_model->csvImport($row);
                        $i++;
                    } 
                    // else {
                    //     echo "invalid_csv_file";
                    //     die();
                    //     // set_alert('error', translate('invalid_csv_file'));
                    //     // redirect(base_url("student/csv_import"));
                    // }
                }
                if ($err_msg != null) {
                    $this->session->set_flashdata('csvimport', $err_msg);
                }
                if ($i > 0) {
                    set_alert('success', $i . ' Database has Been Updated');
                }
                set_alert('success', "Update Successfully");
                $array  = array('status' => 'success',);
            }
        } else {
            $error = $this->form_validation->error_array();
            $array = array('status' => 'fail', 'error' => $error);
        }
        echo json_encode($array);
    }
}
