<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @package : Ramom school management system
 * @version : 2.0
 * @developed by : RamomCoder
 * @support : ramomcoder@yahoo.com
 * @author url : http://codecanyon.net/user/RamomCoder
 * @filename : Accounting.php
 * @copyright : Reserved RamomCoders Team
 */

class Download_pdf extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('download_pdf_model');
    }
    public function index()
    {
        if ($_POST) {
            if (is_superadmin_loggedin()) {
                $this->form_validation->set_rules('branch_id', translate('branch'), 'trim|required');
            }
            $this->form_validation->set_rules('class_id', translate('class'), 'trim|required');
            $this->form_validation->set_rules('section_id', translate('section'), 'trim');
            $this->form_validation->set_rules('register_no', translate('register_no'), 'trim');
            if ($this->form_validation->run() !== false) {
                $post = $this->input->post();
                $response = $this->download_pdf_model->pdf($post);
                if (!$response['success']) {
                    set_alert('success', translate($response['msg']));
                    $url = base_url('download_pdf');
                    $array = array('status' => 'fail', 'url' => $url);
                } else {
                    $array = array('status' => 'success', 'msg' => $response);
                }
            } else {
                $error = $this->form_validation->error_array();
                $array = array('status' => 'fail', 'error' => $error);
            }
            echo json_encode($array);
            exit();
            // if ($this->form_validation->run() == true) {
            //     $post = $this->input->post();
            //     $response = $this->download_pdf_model->pdf($post);
            //     if ($response) {
            //         set_alert('success', translate('information_has_been_saved_successfully'));
            //     }
            //     redirect(base_url('branch'));
            // } else {
            //     echo json_encode([
            //         'success' => false,
            //         'error' => $this->form_validation->error_string()
            //     ]);
            //     // $this->data['validation_error'] = true;
            // }
        }
        if (!get_permission('download_pdfs', 'is_view')) {
            access_denied();
        }
        $this->data['sub_page'] = 'download_pdf/index';
        $this->data['main_menu'] = 'settings';
        $this->data['title'] = translate('Download_Pdf');
        $this->data['headerelements'] = array(
            // 'css' => array(
            //     'vendor/dropify/css/dropify.min.css',
            // ),
            // 'js' => array(
            //     'vendor/dropify/js/dropify.min.js',
            // ),
        );
        $this->load->view('layout/index', $this->data);
    }
}
